/*****************************************************************************
 * meta.h: mp4 meta handling
 *****************************************************************************
 * Copyright (C) 2001-2004, 2010, 2014 VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
#ifndef VLC_MP4_META_H_
#define VLC_MP4_META_H_

struct qt_itunes_triplet_data
{
    enum
    {
        iTunSMPB,
        iTunNORM,
        iTunEncodingParams,
    } type;
    union
    {
        struct
        {
            uint32_t delay;
            uint32_t padding;
            uint64_t original_samplescount;
        } SMPB;
        struct
        {
            float volume_adjust;
            float peak;
        } NORM;
        struct
        {
            uint32_t target_bitrate;
            uint32_t target_quality;
        } EncodingParams;
    };
};

typedef void (*qt_itunes_callback)(const struct qt_itunes_triplet_data *, void *);

void SetupMeta( vlc_meta_t *p_meta, const MP4_Box_t *p_udta,
                qt_itunes_callback, void *priv );


#endif
