// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeUInt8Array
 * @brief   strided implicit array of vtkTypeUInt8.
 *
 * vtkStridedTypeUInt8Array is an strided implicit array of values of type vtkTypeUInt8.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeUInt8Array_h
#define vtkStridedTypeUInt8Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeUInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeUInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeUInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeUInt8Array* New();
  static vtkStridedTypeUInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeUInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeUInt8Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeUInt8* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeUInt8* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeUInt8* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeUInt8Array();
  ~vtkStridedTypeUInt8Array() override;

private:
  typedef vtkStridedArray<vtkTypeUInt8> RealSuperclass;

  vtkStridedTypeUInt8Array(const vtkStridedTypeUInt8Array&) = delete;
  void operator=(const vtkStridedTypeUInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeUInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
