// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeInt32Array
 * @brief   soa array of vtkTypeInt32.
 *
 * vtkSOATypeInt32Array is a soa array of values of type vtkTypeInt32.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeInt32Array_h
#define vtkSOATypeInt32Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeInt32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeInt32Array* New();
  static vtkSOATypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeInt32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeInt32Array();
  ~vtkSOATypeInt32Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeInt32> RealSuperclass;

  vtkSOATypeInt32Array(const vtkSOATypeInt32Array&) = delete;
  void operator=(const vtkSOATypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
