// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeUInt64Array
 * @brief   constant implicit array of vtkTypeUInt64.
 *
 * vtkConstantTypeUInt64Array is a constant implicit array of values of type vtkTypeUInt64.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeUInt64Array_h
#define vtkConstantTypeUInt64Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeUInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt64);
#endif

  static vtkConstantTypeUInt64Array* New();
  static vtkConstantTypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeUInt64Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeUInt64 value);

protected:
  vtkConstantTypeUInt64Array();
  ~vtkConstantTypeUInt64Array() override;

private:
  typedef vtkConstantArray<vtkTypeUInt64> RealSuperclass;

  vtkConstantTypeUInt64Array(const vtkConstantTypeUInt64Array&) = delete;
  void operator=(const vtkConstantTypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
