/* === This file is part of Calamares - <https://github.com/calamares> ===
 *
 *   Copyright 2020 - 2025, Anke Boersma <demm@kaosx.us>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick
import QtQuick.Controls
import QtQuick.Window
import QtQuick.Layouts

Item {
    width: parent.width
    height: parent.height
    //focus: true
    //color: "#f2f2f2"

    TextArea {
        id: intro
        //x: 130
        //y: 8
        width: parent.width
        font.pointSize: 12
        textFormat: Text.MarkdownText
        antialiasing: true
        activeFocusOnPress: false
        wrapMode: Text.WordWrap
        text: "## KaOS - 2025.09
----

KaOS is pleased to announce the availability of the November release of a new stable ISO.

## Latest News for this ISO

The KaOS Plasma Midna theme has undergone a complete overhaul, this included a new icon set, changes in the Login and Ksplash screen, new default wallpaper, modernized window decoration and colorscheme.

**KCP** (KaOS Community Packages) was the last part of KaOS that still used closed source git, it has now also moved to Codeberg. The manager (called kcp), was completely rewritten. First part to accommodate a full migration of all (about 370) repositories to Codeberg, second part to get better accuracy in the PKGBUILD parsing.

Qt5 has been end of life for quite a few years now, but the move of all applications to Qt6 has been slow-going.  With this ISO it is finally at a point that a default install will be Qt5free.
Completely gone now from the repositories are KDE Frameworks Qt5 based.  
Qt5 has not yet been removed from the repositories, so it is still possible to add Qt5 based applications after the installation, those won't have any KDE libraries support though (but complete Qt5 removal is planned for the near future).

For the Plasma desktop, the latest Plasma (6.5.0), KDE Gear (25.08.2), and Frameworks (6.19.0) are included. All built on **Qt 6.10.0**.  News for KDE Gear 25.08 includes, reduced memory usage of various Akonadi resources by around 75% each, Dolphin now offers two search engines that will help you find that specific, but elusive file or folder you can’t locate (File Indexing & Simple search) and Neochat can now create polls and open a context menu for each individual thread of messages

Updates to the base of the system were numerous and included Boost 1.89.0, ICU 77.1, Git 2.51, KBD 2.9.0, Opencv 4.12.0, Openexr 3.4.0, Proj 9.7.0, Poppler 25.10.0, Gstreamer 1.26.7, Pipewire 1.4.8, kernel moved to Linux 6.17.4, Systemd 254.27, ZFS 2.3.4, Meson 1.9.1, OpenSSL 3.5.4, Bash 5.3, Protobuf 33.0 and Mesa 25.2.5.

Among the new packages included **Typst**, a new markup-based typesetting system that is powerful and easy to learn, **Plasma-bigscreen**, a user-friendly interface designed for devices like HTPCs and SBCs connected to TVs and projectors and **Hydrogen**, both a drum sequencer for pattern-based programming and a drum synth.

## Common Notes

A new Phonon sound backend is in use. So far VLC was used, but there is no Qt6 porting for VLC yet. Using **phonon-mpv** as default now, gives a fully Qt 6 ready backend.

SDDM 0.20.0 added the option to run this display manager in Wayland mode, so KaOS is one step closer to being ready to move away from X11. The shell used to run in Wayland mode is kwin_wayland (upstream default is using Weston). **Wayland is the default for SDDM with the move to 0.21.0.**

The automated partitioning option in the installer (Calamares) offers the use of all popular file-systems, so no need to use manually partitioning to be able to choose XFS, EXT4, BTRFS or ZFS.

Big thanks goes to **YourHostingSolutions** for not only providing a mirror, but also providing a server for KaOS. With the discontinuation of Fosshost, a new server was sorely needed.

To get good logs has always been a bit of a challenge since you have to know what journalctl commands to use. That is now a thing of the past, **Kjournald** gives the option to view the logs from a nice GUI, with all kinds of filter options in the left-hand pane (it is now part of the default install)

IWD has replaced Wpa_Suplicant as the default wireless daemon for KaOS.
Similar, Pipewire has replaced PulseAudio as the default sound/low-level multimedia framework.

For Nvidia, longterm supported version 470xx is included, alongside the latest released version.

KaOS' creation **Croeso** (Welsh for welcome) for helping with configuring a new installation is included. It will run on the newly installed system and offers to adjust some 15 commonly used settings, includes a custom Wallpaper selector, distribution info, and the option to select packages to install from six different groups. It is written in QML and fits well with the Welcome application used in the Live system. The latter includes an Installation Guide.

There is an option to verify the authenticity of downloaded KaOS ISO files through GPG signature verification, see the Download page for further details and instructions.

The artwork includes a custom icon theme. Midna creates a complete unified look from boot-up all the way through logout.

This ISO uses the **CRC and finobt enabled** XFS filesystem as default. CRCs enable enhanced error detection due to hardware issues, whilst the format changes also improves crash recovery algorithms and the ability of various tools to validate and repair metadata corruptions when they are found. The free inode btree does not index used inodes, allowing faster, more consistent inode allocation performance as filesystems age.

**Octopi** is a crucial part of full system maintenance for KaOS. It is not just a GUI frontend to pacman. Tools like making sure a mirror is synced before starting any update, looking at the pacman logs, an option to get a paste from a complete snapshot of all info of a system with the SysInfo tool are included. Also included are very simple ways to open files, like copy to clipboard the file path shown in Octopi. To make sure the system doesn't start using too much disk space for the pacman cache, but still giving the user the option to retain some recent packages, the cache-cleaner tool is a great addition. The built-in tool to access **KCP** has now a much clearer place with the addition of its own foreign icon in the menu-bar. New added is the option to select custom icons for the systemtray.

For UEFI installs, KaOS uses the simple, transparent but quite powerful systemd-boot as bootloader.

To learn more about the goals and ideas behind KaOS, please read the **https://kaosx.us/** and **https://kaosx.us/#faq/** pages.

To avoid any misunderstanding and confusion, KaOS is **not based upon, derived of, or inspired by** any one particular distribution. It is completely independent, build entirely from scratch with its own repositories. To read more about this see **https://kaosx.us/#faq/**. A **rolling release distribution** never has a final release, every ISO is merely a snapshot of the current status of the repositories. An idea what is currently available:

The ISO ships with **Frameworks 6.19.0, Plasma 6.5.0, KDE Applications 25.08.2**, Linux 6.17.4, Systemd 254.27, Kmod 34.2, NetworkManager 1.54, Calligra 25.08.2, Elisa, Xorg-Server 1.21.18, Mesa 25.2.5, Glibc 2.41, GCC 14.2.1, non-free Nvidia 580 and Python3 3.11.14 to name a few.

The package manager is **Pacman 7.0.0**, with the simple but powerful Octopi 0.18.1 as GUI frontend. Falkon is the default, Qt based, web browser. **GFXboot** is included with KaOS artwork, Grub theme is Midna, Look &amp; Feel is a KaOS exclusive version Midna.

**Repositories** of KaOS will stay limited in size and expect it to stay at the current maximum of about 2100-2200 packages. A gist of what is available, besides the stable kernel there is Linux-next 6.17, LibreOffice 25.8.2, VLC, Vokoscreen, Blender, Kodi, Calibre, Sigil, Vulkan packages, a few games like 0ad and Knights.
A limited number of the most well-known GTK applications are available, for example, Firefox 144, Chrome 143, Ardour 8.12.0, Inkscape 1.4, GIMP 3.0.6 and Thunderbird 144. Complete language packs are available for KDE, Calligra, Firefox, LibreOffice and Thunderbird. For IM, Fcitx 5.1.14 is available as a rather complete group.

## Known issues:

- Installing on RAID is currently not possible

**To create reliable** installation media, please follow the instructions from the **https://kaosx.us/download/** page. KaOS's ISO's **do not support Unetbootin or Rufus**, and DVDs need a burn speed **no higher than 4x**."
    }

    /*ToolButton {
        id: toolButton
        x: 19
        y: 29
        width: 105
        height: 48
        text: qsTr("Back")
        hoverEnabled: true
        onClicked: load.source = ""

        Image {
            id: image1
            x: 0
            y: 13
            width: 22
            height: 22
            source: "file:/usr/share/pixmaps/chevron-left-solid.svg"
            fillMode: Image.PreserveAspectFit
        }
    }*/

}
