/* === This file is part of Calamares - <https://github.com/calamares> ===
 *
 *   Copyright 2020 - 2026, Anke Boersma <demm@kaosx.us>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick
import QtQuick.Controls
import QtQuick.Window
import QtQuick.Layouts

Item {
    width: parent.width
    height: parent.height
    //focus: true
    //color: "#f2f2f2"

    TextArea {
        id: intro
        //x: 130
        //y: 8
        width: parent.width
        font.pointSize: 12
        textFormat: Text.MarkdownText
        antialiasing: true
        activeFocusOnPress: false
        wrapMode: Text.WordWrap
        text: "## KaOS - 2026.01
----

KaOS kicks of the New Year with a complete change from what you expect from this distribution.

You will not find Plasma or Kwin on this ISO, though KaOS has always been a KDE/Plasma only distribution.  
Instead, you will find a Niri/Noctalia based system.  For those wondering why this change, it has come into play because of a desire to move away from Systemd.  Work is ongoing to see if a move to Dinit is viable for this distribution, that also meant, looking for an alternative to Plasma, since Plasma pretty much demands Systemd, and will be fully mandatory soon.  This ISO still uses Systemd fully though.  
Trials to use Niri with the Noctalia shell have proven to be a nice option.  Using these means, KaOS can stay a Qt focused distribution.  This ISO is still GTK free, still ships QT/KDE based applications.  
The change for this ISO however doesn't mean it is permanent.  Plasma 6 is still fully available in the repositories.  Using an ISO though for wider testing and gaging general response for such a move, was deemed a needed option.

With this ISO, Limine is now the default bootloader. Other options for UEFI installs are still available in Calamares, but Limine has replaced systemd-boot as default.

For the desktop shell, the latest Niri (25.11), Noctalia (4.1.1), and Quickshell (0.2.1) are included. All built on **Qt 6.10.1**.  To complete this setup, options like cliphist, seatd, ddcutil, pavucontrol-qt, qt6ct and xwayland-satellite are installed.

This ISO also moves to a newer systemd. 254 is now a few years old (still maintained upstream, but looks like that won't be the case much longer, it was the last version fully supporting a split /usr setup like KaOS is using). Running an install on systemd 257 has been tested a while now, creating an ISO with it still fails, so the ISO has systemd 255.22, the installs will move to 257.10.

The installer, Calamares, no longer links to a browser in the Welcome page for additional information.  Opening a browser as root has always been problematic (Calamares runs as root), that has now been replaced by a QML Drawer with some extra information.

Updates to the base of the system were numerous and a new GCC 15.2.1, Glibc 2.42 & Binutils 2.45.1 based Toolchain, Opencv 4.12.0, Poppler 26.01.0, Gstreamer 1.26.10, Pipewire 1.4.9, kernel moved to Linux 6.18.6, Systemd 257.10, ZFS 2.4.0, Cmake 4.2, OpenSSH 10.2, Bash 5.3, Protobuf 33.4 and Mesa 25.3.3.

Among the new packages included **Niri**, a Scrollable-tiling Wayland compositor, **Quickshell**, a Flexible toolkit for making desktop shells with QtQuick for Wayland and **Noctalia Shell**, minimal desktop shell for Wayland that actually gets out of your way.

## Common Notes

A new Phonon sound backend is in use. So far, VLC was used, but there is no Qt6 porting for VLC yet. Using **phonon-mpv** as default now, gives a fully Qt 6 ready backend.

SDDM 0.20.0 added the option to run this display manager in Wayland mode, so KaOS is one step closer to being ready to move away from X11. The shell used to run in Wayland mode is kwin_wayland (upstream default is using Weston). **Wayland is the default for SDDM with the move to 0.21.0.**

The automated partitioning option in the installer (Calamares) offers the use of all popular file-systems, so no need to use manually partitioning to be able to choose XFS, EXT4, BTRFS or ZFS.

Big thanks goes to **YourHostingSolutions** for not only providing a mirror, but also providing a server for KaOS. With the discontinuation of Fosshost, a new server was sorely needed.

To get good logs has always been a bit of a challenge, since you have to know what journalctl commands to use. That is now a thing of the past, **Kjournald** gives the option to view the logs from a nice GUI, with all kinds of filter options in the left-hand pane (it is now part of the default install)

IWD has replaced Wpa_Suplicant as the default wireless daemon for KaOS.
Similar, Pipewire has replaced PulseAudio as the default sound/low-level multimedia framework.

For Nvidia, long-term supported version 470xx is included, alongside the latest released version.

KaOS' creation **Croeso** (Welsh for welcome) for helping with configuring a new installation is included. It will run on the newly installed system and offers to adjust some 15 commonly used settings, includes a custom Wallpaper selector, distribution info, and the option to select packages to install from six different groups. It is written in QML and fits well with the Welcome application used in the Live system. The latter includes an Installation Guide.

There is an option to verify the authenticity of downloaded KaOS ISO files through GPG signature verification, see the Download page for further details and instructions.

The artwork includes a custom icon theme. Midna creates a complete unified look from boot-up all the way through logout.

This ISO uses the **CRC and finobt enabled** XFS filesystem as default. CRCs enable enhanced error detection due to hardware issues, whilst the format changes also improves crash recovery algorithms and the ability of various tools to validate and repair metadata corruptions when they are found. The free inode btree does not index used inodes, allowing faster, more consistent inode allocation performance as filesystems age.

**Octopi** is a crucial part of full system maintenance for KaOS. It is not just a GUI frontend to pacman. Tools like making sure a mirror is synced before starting any update, looking at the pacman logs, an option to get a paste from a complete snapshot of all info of a system with the SysInfo tool are included. Also included are very simple ways to open files, like copy to clipboard the file path shown in Octopi. To make sure the system doesn't start using too much disk space for the pacman cache, but still giving the user the option to retain some recent packages, the cache-cleaner tool is a great addition. The built-in tool to access **KCP** has now a much clearer place with the addition of its own foreign icon in the menu-bar. New added is the option to select custom icons for the systemtray.

To learn more about the goals and ideas behind KaOS, please read the **https://kaosx.us/** and **https://kaosx.us/#faq/** pages.

To avoid any misunderstanding and confusion, KaOS is **not based upon, derived of, or inspired by** any one particular distribution. It is completely independent, build entirely from scratch with its own repositories. To read more about this see **https://kaosx.us/#faq/**. A **rolling release distribution** never has a final release, every ISO is merely a snapshot of the current status of the repositories. An idea of what is currently available:

The ISO ships with **Niri & Noctalia**, Linux 6.18.6, Systemd 255.22, Kmod 34.2, NetworkManager 1.54, Calligra 25.12.1, Elisa, Xorg-Server 1.21.21, Mesa 25.3.3, Glibc 2.42, GCC 15.2.1, non-free Nvidia 590 and Python3 3.11.14 to name a few.

The package manager is **Pacman 7.0.0**, with the simple but powerful Octopi 0.18.1 as GUI frontend. Falkon is the default, Qt based, web browser. **GFXboot** is included with KaOS artwork, Grub theme is Midna, Look &amp; Feel is a KaOS exclusive version Midna.

**Repositories** of KaOS will stay limited in size and expect it to stay at the current maximum of about 2100-2200 packages. A gist of what is available, besides the stable kernel there is Linux-next 6.18, LibreOffice 25.8.4, VLC, Vokoscreen, Blender, Kodi, Calibre, Sigil, Vulkan packages, a few games like 0ad and Knights.
A limited number of the most well-known GTK applications are available, for example, Firefox 147, Chrome 146, Ardour 8.12.0, Inkscape 1.4, GIMP 3.0.6 and Thunderbird 146. Complete language packs are available for KDE, Calligra, Firefox, LibreOffice and Thunderbird. For IM, Fcitx 5.1.17 is available as a rather complete group.

## Known issues:

- Installing on RAID is currently not possible

**To create reliable** installation media, please follow the instructions from the **https://kaosx.us/download/** page. KaOS's ISO's **do not support Unetbootin or Rufus**, and DVDs need a burn speed **no higher than 4x**."
    }

    /*ToolButton {
        id: toolButton
        x: 19
        y: 29
        width: 105
        height: 48
        text: qsTr("Back")
        hoverEnabled: true
        onClicked: load.source = ""

        Image {
            id: image1
            x: 0
            y: 13
            width: 22
            height: 22
            source: "file:/usr/share/pixmaps/chevron-left-solid.svg"
            fillMode: Image.PreserveAspectFit
        }
    }*/

}
