// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeUInt32Array
 * @brief   strided implicit array of vtkTypeUInt32.
 *
 * vtkStridedTypeUInt32Array is an strided implicit array of values of type vtkTypeUInt32.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeUInt32Array_h
#define vtkStridedTypeUInt32Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeUInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeUInt32Array* New();
  static vtkStridedTypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeUInt32Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeUInt32* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeUInt32* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeUInt32* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeUInt32Array();
  ~vtkStridedTypeUInt32Array() override;

private:
  typedef vtkStridedArray<vtkTypeUInt32> RealSuperclass;

  vtkStridedTypeUInt32Array(const vtkStridedTypeUInt32Array&) = delete;
  void operator=(const vtkStridedTypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
