// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeUInt16Array
 * @brief   scaled soa array of vtkTypeUInt16.
 *
 * vtkScaledSOATypeUInt16Array is a scaled soa array of values of type vtkTypeUInt16.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeUInt16Array_h
#define vtkScaledSOATypeUInt16Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeUInt16Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeUInt16Array* New();
  static vtkScaledSOATypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeUInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeUInt16Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeUInt16Array();
  ~vtkScaledSOATypeUInt16Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeUInt16> RealSuperclass;

  vtkScaledSOATypeUInt16Array(const vtkScaledSOATypeUInt16Array&) = delete;
  void operator=(const vtkScaledSOATypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
