// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeInt8Array
 * @brief   soa array of vtkTypeInt8.
 *
 * vtkSOATypeInt8Array is a soa array of values of type vtkTypeInt8.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeInt8Array_h
#define vtkSOATypeInt8Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeInt8Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeInt8Array* New();
  static vtkSOATypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeInt8Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeInt8Array();
  ~vtkSOATypeInt8Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeInt8> RealSuperclass;

  vtkSOATypeInt8Array(const vtkSOATypeInt8Array&) = delete;
  void operator=(const vtkSOATypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
