// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeUInt8Array
 * @brief   affine implicit array of vtkTypeUInt8.
 *
 * vtkAffineTypeUInt8Array is an affine implicit array of values of type vtkTypeUInt8.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeUInt8Array_h
#define vtkAffineTypeUInt8Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeUInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeUInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeUInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeUInt8Array* New();
  static vtkAffineTypeUInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeUInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeUInt8Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeUInt8 slope, vtkTypeUInt8 intercept);

protected:
  vtkAffineTypeUInt8Array();
  ~vtkAffineTypeUInt8Array() override;

private:
  typedef vtkAffineArray<vtkTypeUInt8> RealSuperclass;

  vtkAffineTypeUInt8Array(const vtkAffineTypeUInt8Array&) = delete;
  void operator=(const vtkAffineTypeUInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeUInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
