/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import vtk.sample.VTKCanvas;
import vtk.vtkNativeLibrary;

public class InternalFrames
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Desktop theDesktop;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public InternalFrames() {
        super("VTK Internal Frame Demo");
        this.setSize(900, 900);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.addWindowListener(windowAdapter);
        this.getContentPane().add(new SplitFrame());
        new MenuMgr();
        this.setVisible(true);
    }

    public void addMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new InternalFrames();
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    private class Desktop
    extends JDesktopPane {
        private static final long serialVersionUID = 1L;

        public Desktop() {
            this.setPreferredSize(InternalFrames.this.screenSize);
            this.setDragMode(1);
            this.add(new VTKFrame(10, 10));
            this.add(new VTKFrame(500, 10));
        }
    }

    private class SplitFrame
    extends JSplitPane {
        private static final long serialVersionUID = 1L;

        public SplitFrame() {
            super(0);
            this.setDividerLocation(((InternalFrames)InternalFrames.this).screenSize.height / 2);
            this.setContinuousLayout(true);
            this.setOneTouchExpandable(true);
            this.add(InternalFrames.this.theDesktop = new Desktop());
            this.add(new Tabbed());
        }
    }

    private class MenuMgr
    extends JMenuBar {
        private static final long serialVersionUID = 1L;
        private JMenu menu;

        public MenuMgr() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.menu = new JMenu("File");
            this.menu.add(new CreateWindowAction("Create New VTK Window"));
            this.menu.add(new KillAction("Exit"));
            this.add(this.menu);
            InternalFrames.this.addMenuBar(this);
        }
    }

    private class KillAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public KillAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class CreateWindowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int layer;

        public CreateWindowAction(String string) {
            super(string);
            this.layer = 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InternalFrames.this.theDesktop.add((Component)new VTKFrame(340, 200), (Object)this.layer);
        }
    }

    private class VTKFrame
    extends JInternalFrame {
        private static final long serialVersionUID = 1L;

        public VTKFrame(int n, int n2) {
            super("VTK Window", true, true, true, true);
            Dimension dimension = new Dimension();
            dimension.height = 300;
            dimension.width = 300;
            this.setSize(dimension);
            this.getContentPane().setLayout(new BorderLayout());
            this.setLocation(n, n2);
            this.getContentPane().add((Component)new VTKCanvas(), "Center");
            this.pack();
            this.setVisible(true);
        }
    }

    private class Tabbed
    extends JTabbedPane {
        private static final long serialVersionUID = 1L;

        public Tabbed() {
            this.addTab("vtk1", new VTKCanvas());
            this.addTab("vtk2", new VTKCanvas());
            this.setMinimumSize(new Dimension(300, 300));
            this.setSelectedIndex(1);
        }
    }
}

