// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) DIGITEO - 2015-2015 - Clément DAVID
//
// This file is distributed under the same license as the Scilab package.

// <-- XCOS TEST -->
// <-- NO CHECK REF -->
//
// <-- Short Description -->
// Internal test to check that xcos files and zcos files can be loaded and saved as SSP files

files = [ ..
'contrib/xcos_toolbox_skeleton/demos/Blocks.zcos'
'contrib/xcos_toolbox_skeleton/examples/AllSum.zcos'
'contrib/xcos_toolbox_skeleton/tests/benchmark/noop_matrices.zcos'
'contrib/xcos_toolbox_skeleton/tests/benchmark/noop_scalar.zcos'
'modules/scicos_blocks/tests/nonreg_tests/VEress9-2D4.zcos'
'modules/scicos_blocks/tests/nonreg_tests/bug_14551.zcos'
'modules/scicos_blocks/tests/nonreg_tests/bug_15464/call_lib.zcos'
'modules/scicos_blocks/tests/nonreg_tests/bug_15979.zcos'
'modules/xcos/demos/Bouncing_ball.zcos'
'modules/xcos/demos/CodeGen/controller.zcos'
'modules/xcos/demos/CodeGen/fibo.zcos'
'modules/xcos/demos/Command.zcos'
'modules/xcos/demos/Command_bode.zcos'
'modules/xcos/demos/Cont.Disc-Observer.zcos'
'modules/xcos/demos/Controller.zcos'
'modules/xcos/demos/Discrete-KalmanFilter.zcos'
'modules/xcos/demos/Electrical/AND_Gate.zcos'
'modules/xcos/demos/Electrical/Boost_Converter.zcos'
'modules/xcos/demos/Electrical/Bridge_Rectifier.zcos'
'modules/xcos/demos/Electrical/Colpitts_Oscillator.zcos'
'modules/xcos/demos/Electrical/DC_DC_Buck_Converter.zcos'
'modules/xcos/demos/Electrical/Difference_amplifier.zcos'
'modules/xcos/demos/Electrical/NOR_Gate.zcos'
'modules/xcos/demos/Electrical/Opamp_Amplifier.zcos'
'modules/xcos/demos/Electrical/Switched_capacitor_integrator.zcos'
'modules/xcos/demos/Electrical/Transformer.zcos'
'modules/xcos/demos/Event/event_and.zcos'
'modules/xcos/demos/Event/if_then_else.zcos'
'modules/xcos/demos/Fibonacci.zcos'
'modules/xcos/demos/IF_block.zcos'
'modules/xcos/demos/Ifsub.zcos'
'modules/xcos/demos/Inverted_pendulum.zcos'
'modules/xcos/demos/Kalman.zcos'
'modules/xcos/demos/Kalman_1.zcos'
'modules/xcos/demos/Lorenz.zcos'
'modules/xcos/demos/ModelicaBlocks/Ball_Platform.zcos'
'modules/xcos/demos/ModelicaBlocks/BouncingBall_Modelica.zcos'
'modules/xcos/demos/ModelicaBlocks/Chaos_Modelica.zcos'
'modules/xcos/demos/ModelicaBlocks/Heat_conduction.zcos'
'modules/xcos/demos/ModelicaBlocks/Hydraulics.zcos'
'modules/xcos/demos/ModelicaBlocks/RLC_Modelica.zcos'
'modules/xcos/demos/ModelicaBlocks/Rotational_system.zcos'
'modules/xcos/demos/OldGainTest.zcos'
'modules/xcos/demos/Plant_DiscreteController.zcos'
'modules/xcos/demos/Scilab_Block.zcos'
'modules/xcos/demos/Signal_Builder.zcos'
'modules/xcos/demos/Simple_Demo.zcos'
'modules/xcos/demos/Simple_Thermostat.zcos'
'modules/xcos/demos/System-Observer.zcos'
'modules/xcos/demos/Table_Lookup.zcos'
'modules/xcos/demos/Temperature_Controller.zcos'
'modules/xcos/demos/Thermique_bloc.zcos'
'modules/xcos/demos/Threshold_ZeroCrossing.zcos'
'modules/xcos/demos/batch_simulation.zcos'
'modules/xcos/demos/bounce.zcos'
'modules/xcos/demos/demo_Datatype.zcos'
'modules/xcos/demos/demo_watertank.zcos'
'modules/xcos/demos/goto_demo.zcos'
'modules/xcos/demos/optimal_link.zcos'
'modules/xcos/demos/optimal_split_block.zcos'
'modules/xcos/demos/pendulum_anim5.zcos'
'modules/xcos/demos/susp.zcos'
'modules/xcos/examples/CLSS.zcos'
'modules/xcos/examples/annotations_pal/en_US/text_f_en_US.zcos'
'modules/xcos/examples/annotations_pal/fr_FR/text_f_fr_FR.zcos'
'modules/xcos/examples/continuous_pal/CLSS_Example.zcos'
'modules/xcos/examples/continuous_pal/DERIV_Example.zcos'
'modules/xcos/examples/continuous_pal/INTEGRAL_m_1_Example.zcos'
'modules/xcos/examples/continuous_pal/INTEGRAL_m_2_Example.zcos'
'modules/xcos/examples/continuous_pal/PID_1_Example.zcos'
'modules/xcos/examples/continuous_pal/PID_2_Example.zcos'
'modules/xcos/examples/continuous_pal/PID_3_Example.zcos'
'modules/xcos/examples/continuous_pal/PID_internal.zcos'
'modules/xcos/examples/continuous_pal/TCLSS_Example.zcos'
'modules/xcos/examples/continuous_pal/TIME_DELAY_Example.zcos'
'modules/xcos/examples/continuous_pal/en_US/VARIABLE_DELAY_en_US.zcos'
'modules/xcos/examples/continuous_pal/fr_FR/VARIABLE_DELAY_fr_FR.zcos'
'modules/xcos/examples/derivative.zcos'
'modules/xcos/examples/discontinuities_pal/BACKLASH_Example.zcos'
'modules/xcos/examples/discontinuities_pal/HYSTERESIS_Example.zcos'
'modules/xcos/examples/discontinuities_pal/RATELIMITER_Example.zcos'
'modules/xcos/examples/discontinuities_pal/SATURATION_Example.zcos'
'modules/xcos/examples/discontinuities_pal/en_US/deadband_en_US.zcos'
'modules/xcos/examples/discontinuities_pal/fr_FR/deadband_fr_FR.zcos'
'modules/xcos/examples/discrete_pal/en_US/DELAYV_f_en_US.zcos'
'modules/xcos/examples/discrete_pal/en_US/DELAY_f_1_en_US.zcos'
'modules/xcos/examples/discrete_pal/en_US/DELAY_f_2_en_US.zcos'
'modules/xcos/examples/discrete_pal/fr_FR/DELAY_f_1_fr_FR.zcos'
'modules/xcos/examples/electrical_pal/IdealTransformer_Example.zcos'
'modules/xcos/examples/events_pal/ANDBLK_Example.zcos'
'modules/xcos/examples/events_pal/ANDLOG_f_Example.zcos'
'modules/xcos/examples/events_pal/CEVENTSCOPE_Example.zcos'
'modules/xcos/examples/events_pal/CLKSOMV_f_Example.zcos'
'modules/xcos/examples/events_pal/EDGE_TRIGGER_Example.zcos'
'modules/xcos/examples/events_pal/ESELECT_f_Example.zcos'
'modules/xcos/examples/events_pal/EVTDLY_c_Example.zcos'
'modules/xcos/examples/events_pal/EVTGEN_f_Example.zcos'
'modules/xcos/examples/events_pal/EVTVARDLY_Example.zcos'
'modules/xcos/examples/events_pal/Extract_Activation_Example.zcos'
'modules/xcos/examples/events_pal/IFTHEL_f_Example.zcos'
'modules/xcos/examples/events_pal/MCLOCK_f_Example.zcos'
'modules/xcos/examples/events_pal/MFCLCK_f_Example.zcos'
'modules/xcos/examples/events_pal/M_freq_Example.zcos'
'modules/xcos/examples/events_pal/en_US/freq_div_en_US.zcos'
'modules/xcos/examples/implicit_pal/DIFF_f_Example.zcos'
'modules/xcos/examples/integer_pal/en_US/BITCLEAR_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/BITSET_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/CONVERT_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/DLATCH_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/EXTRACTBITS_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/INTMUL_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/JKFLIPFLOP_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/LOGIC_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/SHIFT_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/SHIFT_internal_en_US.zcos'
'modules/xcos/examples/integer_pal/en_US/SRFLIPFLOP_en_US.zcos'
'modules/xcos/examples/integer_pal/fr_FR/BITCLEAR_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/BITSET_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/CONVERT_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/DLATCH_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/EXTRACTBITS_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/INTMUL_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/JKFLIPFLOP_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/LOGIC_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/SHIFT_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/SHIFT_internal_fr_FR.zcos'
'modules/xcos/examples/integer_pal/fr_FR/SRFLIPFLOP_fr_FR.zcos'
'modules/xcos/examples/lookuptables_pal/en_US/INTRPLBLK_f_en_US.zcos'
'modules/xcos/examples/mathoperations_pal/ABS_VALUE_Example.zcos'
'modules/xcos/examples/mathoperations_pal/BIGSOM_f_Example.zcos'
'modules/xcos/examples/mathoperations_pal/EXPRESSION.zcos'
'modules/xcos/examples/mathoperations_pal/MIN_f_Example.zcos'
'modules/xcos/examples/matrix_pal/CUMSUM_Example.zcos'
'modules/xcos/examples/matrix_pal/EXTRACT_Example.zcos'
'modules/xcos/examples/matrix_pal/EXTTRI_Example.zcos'
'modules/xcos/examples/matrix_pal/MATBKSL_Example.zcos'
'modules/xcos/examples/matrix_pal/MATCATH_Example.zcos'
'modules/xcos/examples/matrix_pal/MATCATV_Example.zcos'
'modules/xcos/examples/matrix_pal/MATDET_Example.zcos'
'modules/xcos/examples/matrix_pal/MATDIAG_Example.zcos'
'modules/xcos/examples/matrix_pal/MATDIV_Example.zcos'
'modules/xcos/examples/matrix_pal/MATEIG_Example.zcos'
'modules/xcos/examples/matrix_pal/MATEXPM_Example.zcos'
'modules/xcos/examples/matrix_pal/MATINV_Example.zcos'
'modules/xcos/examples/portaction_pal/en_US/CLKINV_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/CLKINV_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/CLKOUTV_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/CLKOUTV_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/INIMPL_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/INIMPL_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/IN_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/IN_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/OUTIMPL_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/OUTIMPL_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/OUT_f_en_US.zcos'
'modules/xcos/examples/portaction_pal/en_US/OUT_f_internal_en_US.zcos'
'modules/xcos/examples/portaction_pal/fr_FR/CLKINV_f_fr_FR.zcos'
'modules/xcos/examples/portaction_pal/fr_FR/CLKOUTV_f_fr_FR.zcos'
'modules/xcos/examples/portaction_pal/fr_FR/INIMPL_f_fr_FR.zcos'
'modules/xcos/examples/portaction_pal/fr_FR/IN_f_fr_FR.zcos'
'modules/xcos/examples/portaction_pal/fr_FR/OUT_f_fr_FR.zcos'
'modules/xcos/examples/signalprocessing_pal/QUANT_f_Example.zcos'
'modules/xcos/examples/signalprocessing_pal/QUANT_f_Example_Quantization_Mode.zcos'
'modules/xcos/examples/signalprocessing_pal/SAMPHOLD_m_Example.zcos'
'modules/xcos/examples/signalrouting_pal/M_SWITCH.zcos'
'modules/xcos/examples/signalrouting_pal/RELAY_f_Example.zcos'
'modules/xcos/examples/signalrouting_pal/SELECT_m_Example.zcos'
'modules/xcos/examples/signalrouting_pal/SELF_SWITCH_on_off_Example.zcos'
'modules/xcos/examples/signalrouting_pal/SWITCH2_m_Example.zcos'
'modules/xcos/examples/sinks_pal/AFFICH_m_Example.zcos'
'modules/xcos/examples/sinks_pal/BARXY_Example.zcos'
'modules/xcos/examples/sinks_pal/CANIMXY3D_Example.zcos'
'modules/xcos/examples/sinks_pal/CANIMXY_Example.zcos'
'modules/xcos/examples/sinks_pal/CMAT3D_Example.zcos'
'modules/xcos/examples/sinks_pal/CMATVIEW_Example.zcos'
'modules/xcos/examples/sinks_pal/ENDBLK_Example.zcos'
'modules/xcos/examples/sinks_pal/END_c_Example.zcos'
'modules/xcos/examples/sinks_pal/TOWS_c_Example.zcos'
'modules/xcos/examples/sinks_pal/TRASH_f_Example.zcos'
'modules/xcos/examples/sinks_pal/WRITEAU_f_Example.zcos'
'modules/xcos/examples/sinks_pal/en_US/CSCOPE_en_US.zcos'
'modules/xcos/examples/sinks_pal/en_US/SCALE_CMSCOPE_en_US.zcos'
'modules/xcos/examples/sinks_pal/en_US/SCALE_CSCOPE_en_US.zcos'
'modules/xcos/examples/sinks_pal/en_US/writec_f_en_US.zcos'
'modules/xcos/examples/sinks_pal/fr_FR/wfile_f_fr_FR.zcos'
'modules/xcos/examples/sinks_pal/fr_FR/writec_f_fr_FR.zcos'
'modules/xcos/examples/solvers/DAE_Example.zcos'
'modules/xcos/examples/solvers/ODE_Example.zcos'
'modules/xcos/examples/solvers/with_ZeroCrossing.zcos'
'modules/xcos/examples/solvers/with_ZeroCrossingSimple.zcos'
'modules/xcos/examples/solvers/without_ZeroCrossing.zcos'
'modules/xcos/examples/solvers/without_ZeroCrossingSimple.zcos'
'modules/xcos/examples/sources_pal/en_US/FROMWSB_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/GENSQR_f_diagram_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/RAMP_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/TKSCALE_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/clock_c_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/counter_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/gensin_f_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/modulo_count_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/rfile_f_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/sawtooth_f_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/step_function_1_en_US.zcos'
'modules/xcos/examples/sources_pal/en_US/step_function_2_en_US.zcos'
'modules/xcos/examples/sources_pal/fr_FR/rfile_f_fr_FR.zcos'
'modules/xcos/examples/userdefinedfunctions_pal/en_US/scifunc_block_m_en_US.zcos'
'modules/xcos/examples/zerocrossingdetection_pal/NEGTOPOS_f_Example.zcos'
'modules/xcos/tests/nonreg_tests/batch_simulation.zcos'
'modules/xcos/tests/nonreg_tests/bug_10781.zcos'
'modules/xcos/tests/nonreg_tests/bug_11193.zcos'
'modules/xcos/tests/nonreg_tests/bug_11913.zcos'
'modules/xcos/tests/nonreg_tests/bug_12057_cmscope.zcos'
'modules/xcos/tests/nonreg_tests/bug_12057_cscope.zcos'
'modules/xcos/tests/nonreg_tests/bug_12266.zcos'
'modules/xcos/tests/nonreg_tests/bug_12384.zcos'
'modules/xcos/tests/nonreg_tests/bug_12414.zcos'
'modules/xcos/tests/nonreg_tests/bug_12424.zcos'
'modules/xcos/tests/nonreg_tests/bug_12731.zcos'
'modules/xcos/tests/nonreg_tests/bug_12751.zcos'
'modules/xcos/tests/nonreg_tests/bug_12868.zcos'
'modules/xcos/tests/nonreg_tests/bug_12869.zcos'
'modules/xcos/tests/nonreg_tests/bug_12874.zcos'
'modules/xcos/tests/nonreg_tests/bug_12998.zcos'
'modules/xcos/tests/nonreg_tests/bug_13059.zcos'
'modules/xcos/tests/nonreg_tests/bug_13318.zcos'
'modules/xcos/tests/nonreg_tests/bug_13396.zcos'
'modules/xcos/tests/nonreg_tests/bug_13436.zcos'
'modules/xcos/tests/nonreg_tests/bug_13513.zcos'
'modules/xcos/tests/nonreg_tests/bug_13758.zcos'
'modules/xcos/tests/nonreg_tests/bug_14637_1.zcos'
'modules/xcos/tests/nonreg_tests/bug_14637_2.zcos'
'modules/xcos/tests/nonreg_tests/bug_15024.zcos'
'modules/xcos/tests/nonreg_tests/bug_15072.zcos'
'modules/xcos/tests/nonreg_tests/bug_15149.zcos'
'modules/xcos/tests/nonreg_tests/bug_15468.zcos'
'modules/xcos/tests/nonreg_tests/bug_15495.zcos'
'modules/xcos/tests/nonreg_tests/bug_2835.zcos'
'modules/xcos/tests/nonreg_tests/bug_4715.zcos'
'modules/xcos/tests/nonreg_tests/bug_4898.zcos'
'modules/xcos/tests/nonreg_tests/bug_5179.zcos'
'modules/xcos/tests/nonreg_tests/bug_5403.zcos'
'modules/xcos/tests/nonreg_tests/bug_5444.zcos'
'modules/xcos/tests/nonreg_tests/bug_5638.zcos'
'modules/xcos/tests/nonreg_tests/bug_5701.zcos'
'modules/xcos/tests/nonreg_tests/bug_6386.zcos'
'modules/xcos/tests/nonreg_tests/bug_6517.zcos'
'modules/xcos/tests/nonreg_tests/bug_6527.zcos'
'modules/xcos/tests/nonreg_tests/bug_6578.zcos'
'modules/xcos/tests/nonreg_tests/bug_6797.zcos'
'modules/xcos/tests/nonreg_tests/bug_6814.zcos'
'modules/xcos/tests/nonreg_tests/bug_7015.zcos'
'modules/xcos/tests/nonreg_tests/bug_7315.zcos'
'modules/xcos/tests/nonreg_tests/bug_7396.zcos'
'modules/xcos/tests/nonreg_tests/bug_7424.zcos'
'modules/xcos/tests/nonreg_tests/bug_7639.zcos'
'modules/xcos/tests/nonreg_tests/bug_7985.zcos'
'modules/xcos/tests/nonreg_tests/bug_8042.zcos'
'modules/xcos/tests/nonreg_tests/bug_8235.zcos'
'modules/xcos/tests/nonreg_tests/bug_8348.zcos'
'modules/xcos/tests/nonreg_tests/bug_8441.zcos'
'modules/xcos/tests/nonreg_tests/bug_8480.zcos'
'modules/xcos/tests/nonreg_tests/bug_8483.zcos'
'modules/xcos/tests/nonreg_tests/bug_8569.zcos'
'modules/xcos/tests/nonreg_tests/bug_8630.zcos'
'modules/xcos/tests/nonreg_tests/bug_8674.zcos'
'modules/xcos/tests/nonreg_tests/bug_8692.zcos'
'modules/xcos/tests/nonreg_tests/bug_8735.zcos'
'modules/xcos/tests/nonreg_tests/bug_8737.zcos'
'modules/xcos/tests/nonreg_tests/bug_8744.zcos'
'modules/xcos/tests/nonreg_tests/bug_8822.zcos'
'modules/xcos/tests/nonreg_tests/bug_8867.zcos'
'modules/xcos/tests/nonreg_tests/bug_8884.zcos'
'modules/xcos/tests/nonreg_tests/bug_9307.zcos'
'modules/xcos/tests/nonreg_tests/bug_9346.zcos'
'modules/xcos/tests/nonreg_tests/bug_9386.zcos'
'modules/xcos/tests/nonreg_tests/bug_9810.zcos'
'modules/xcos/tests/nonreg_tests/bug_cmscope.zcos'
'modules/xcos/tests/nonreg_tests/bug_cscope.zcos'
'modules/xcos/tests/nonreg_tests/constant.zcos'
'modules/xcos/tests/nonreg_tests/delay_anal.zcos'
'modules/xcos/tests/nonreg_tests/disease.zcos'
'modules/xcos/tests/nonreg_tests/gain.zcos'
'modules/xcos/tests/nonreg_tests/gensin.zcos'
'modules/xcos/tests/nonreg_tests/gensin_2.zcos'
'modules/xcos/tests/nonreg_tests/gensin_3.zcos'
'modules/xcos/tests/nonreg_tests/gensin_4.zcos'
'modules/xcos/tests/nonreg_tests/inputfile.zcos'
'modules/xcos/tests/nonreg_tests/integral.zcos'
'modules/xcos/tests/nonreg_tests/integral_2.zcos'
'modules/xcos/tests/nonreg_tests/integral_multi.zcos'
'modules/xcos/tests/nonreg_tests/integral_multi_2.zcos'
'modules/xcos/tests/nonreg_tests/integral_multi_3.zcos'
'modules/xcos/tests/nonreg_tests/integral_sawtooth.zcos'
'modules/xcos/tests/nonreg_tests/integral_sawtooth_sin.zcos'
'modules/xcos/tests/nonreg_tests/intro_qq.zcos'
'modules/xcos/tests/nonreg_tests/lut.zcos'
'modules/xcos/tests/nonreg_tests/modelica_RLC.zcos'
'modules/xcos/tests/nonreg_tests/nonlinear.zcos'
'modules/xcos/tests/nonreg_tests/outputfile.zcos'
'modules/xcos/tests/nonreg_tests/ramp_sawtooth.zcos'
'modules/xcos/tests/nonreg_tests/rossler.zcos'
'modules/xcos/tests/nonreg_tests/sardines.zcos'
'modules/xcos/tests/nonreg_tests/sigbuild.zcos'
'modules/xcos/tests/nonreg_tests/state.zcos'
'modules/xcos/tests/nonreg_tests/test_affich_m.zcos'
'modules/xcos/tests/nonreg_tests/threshold.zcos'
'modules/xcos/tests/nonreg_tests/transferfcn.zcos'
'modules/xcos/tests/unit_tests/Integer/clear_bit.zcos'
'modules/xcos/tests/unit_tests/Integer/dflipflop.zcos'
'modules/xcos/tests/unit_tests/Integer/dlatch.zcos'
'modules/xcos/tests/unit_tests/Integer/extract_bits.zcos'
'modules/xcos/tests/unit_tests/Integer/intmul.zcos'
'modules/xcos/tests/unit_tests/Integer/iselect.zcos'
'modules/xcos/tests/unit_tests/Integer/jkflipflop.zcos'
'modules/xcos/tests/unit_tests/Integer/logic.zcos'
'modules/xcos/tests/unit_tests/Integer/matmul.zcos'
'modules/xcos/tests/unit_tests/Integer/samphold.zcos'
'modules/xcos/tests/unit_tests/Integer/select.zcos'
'modules/xcos/tests/unit_tests/Integer/set_bit.zcos'
'modules/xcos/tests/unit_tests/Integer/shift.zcos'
'modules/xcos/tests/unit_tests/Integer/srflipflop.zcos'
'modules/xcos/tests/unit_tests/Integer/summation.zcos'
'modules/xcos/tests/unit_tests/Integer/switch2_m.zcos'
'modules/xcos/tests/unit_tests/Solvers/DAE/Bouncing.zcos'
'modules/xcos/tests/unit_tests/Solvers/DAE/Hydraulics.zcos'
'modules/xcos/tests/unit_tests/Solvers/DAE/Platform.zcos'
'modules/xcos/tests/unit_tests/Solvers/DAE/RLC.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/Cont-Disc.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/Controller.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/IPendulum.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/Kalman.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/Temperature_Controller.zcos'
'modules/xcos/tests/unit_tests/Solvers/ODE/Watertank.zcos'
'modules/xcos/tests/unit_tests/block_tests/ESELECT_f/sinus.zcos'
'modules/xcos/tests/unit_tests/canimxy.zcos'
'modules/xcos/tests/unit_tests/canimxy3d.zcos'
'modules/xcos/tests/unit_tests/cevscpe.zcos'
'modules/xcos/tests/unit_tests/cfscope.zcos'
'modules/xcos/tests/unit_tests/cmatview.zcos'
'modules/xcos/tests/unit_tests/cmatview3d.zcos'
'modules/xcos/tests/unit_tests/cmscope-multi-frequency.zcos'
'modules/xcos/tests/unit_tests/cmscope.zcos'
'modules/xcos/tests/unit_tests/context_update.zcos'
'modules/xcos/tests/unit_tests/cscope.zcos'
'modules/xcos/tests/unit_tests/cscopxy.zcos'
'modules/xcos/tests/unit_tests/cscopxy3d.zcos'
'modules/xcos/tests/unit_tests/cumsum.zcos'
'modules/xcos/tests/unit_tests/empty.zcos'
'modules/xcos/tests/unit_tests/error_blocks_with_not_connected_link.zcos'
'modules/xcos/tests/unit_tests/error_blocks_with_undefined_input.zcos'
// 'modules/xcos/tests/unit_tests/error_blocks_with_undefined_input_on_sb.zcos' // failure on purpose
'modules/xcos/tests/unit_tests/error_blocks_with_updated_context.zcos'
'modules/xcos/tests/unit_tests/error_blocks_with_updated_context_on_sb.zcos'
'modules/xcos/tests/unit_tests/error_from_without_goto.zcos'
'modules/xcos/tests/unit_tests/error_from_without_goto_on_sb.zcos'
'modules/xcos/tests/unit_tests/error_goto_same_tag.zcos'
'modules/xcos/tests/unit_tests/error_goto_same_tag_on_sb.zcos'
'modules/xcos/tests/unit_tests/error_on_block.zcos'
'modules/xcos/tests/unit_tests/error_port_block_on_diagram.zcos'
'modules/xcos/tests/unit_tests/error_ports_with_incompatible_size.zcos'
'modules/xcos/tests/unit_tests/error_ports_with_incompatible_size_on_sb.zcos'
'modules/xcos/tests/unit_tests/error_ports_with_negative_size.zcos'
'modules/xcos/tests/unit_tests/error_ports_with_negative_size_on_sb.zcos'
// 'modules/xcos/tests/unit_tests/error_sb_port_numbering.zcos' // failure on purpose
// 'modules/xcos/tests/unit_tests/error_unconnected_sb_input.zcos' // failure on purpose
'modules/xcos/tests/unit_tests/fromws_c.zcos'
'modules/xcos/tests/unit_tests/fromws_tows_c.zcos'
'modules/xcos/tests/unit_tests/one_buffering_scopes.zcos'
'modules/xcos/tests/unit_tests/pending_mux.zcos'
'modules/xcos/tests/unit_tests/pendulum_anim45.zcos'
'modules/xcos/tests/unit_tests/tows_c.zcos'
'modules/xcos/tests/unit_tests/empty.xcos'
];

for i=1:size(files,1)
    file = files(i,:);

    infile = SCI+"/"+file;
    mprintf("IMPORT %s\n", infile);
    scs_m1 = xcosDiagramToScilab(infile);
    
    outfile = TMPDIR+"/"+basename(infile)+".ssp";
    mprintf("EXPORT %s\n", outfile);
    xcosDiagramToScilab(outfile, scs_m1);

    // decompress to check if its a valid ZIP
    xmlfile = decompress(outfile, TMPDIR);
    doc = xmlRead(xmlfile);

    mprintf("REIMPORT %s\n", outfile);
    scs_m2 = xcosDiagramToScilab(outfile);
    
    // basic testing
    assert_checkequal(length(scs_m1.objs), length(scs_m2.objs));
    
//    mprintf("REIMPORT #2 %s\n", outfile);
//    scs_m3 = scicosDiagramToScilab(outfile);
//    
//    assert_checkequal(scs_m2.objs, scs_m3.objs);
end
