/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.rectangle;

import org.scilab.modules.graphic_objects.contouredObject.ClippableContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;

public class Rectangle
extends ClippableContouredObject {
    private double[] upperLeftPoint = new double[3];
    private double width = 0.0;
    private double height = 0.0;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 104: {
                return RectangleProperty.UPPERLEFTPOINT;
            }
            case 105: {
                return RectangleProperty.WIDTH;
            }
            case 106: {
                return RectangleProperty.HEIGHT;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == RectangleProperty.UPPERLEFTPOINT) {
            return this.getUpperLeftPoint();
        }
        if (object == RectangleProperty.WIDTH) {
            return this.getWidth();
        }
        if (object == RectangleProperty.HEIGHT) {
            return this.getHeight();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == RectangleProperty.UPPERLEFTPOINT) {
            this.setUpperLeftPoint((Double[])object2);
        } else if (object == RectangleProperty.WIDTH) {
            this.setWidth((Double)object2);
        } else if (object == RectangleProperty.HEIGHT) {
            this.setHeight((Double)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getHeight() {
        return this.height;
    }

    public GraphicObject.UpdateStatus setHeight(Double d) {
        this.height = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getUpperLeftPoint() {
        Double[] doubleArray = new Double[]{this.upperLeftPoint[0], this.upperLeftPoint[1], this.upperLeftPoint[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setUpperLeftPoint(Double[] doubleArray) {
        this.upperLeftPoint[0] = doubleArray[0];
        this.upperLeftPoint[1] = doubleArray[1];
        this.upperLeftPoint[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getWidth() {
        return this.width;
    }

    public GraphicObject.UpdateStatus setWidth(Double d) {
        this.width = d;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 16;
    }

    private static enum RectangleProperty {
        UPPERLEFTPOINT,
        WIDTH,
        HEIGHT;

    }
}

