/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import org.scilab.modules.types.ScilabSparse;
import org.scilab.modules.types.ScilabSparseException;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabBooleanSparse
implements ScilabType {
    private static final long serialVersionUID = 879625048944109684L;
    private static final int VERSION = 0;
    private int rows;
    private int cols;
    private int nbItem;
    private int[] nbItemRow;
    private int[] colPos;
    private String varName;

    public ScilabBooleanSparse() {
    }

    public ScilabBooleanSparse(boolean bl) {
        if (bl) {
            this.nbItem = 1;
            this.cols = 1;
            this.rows = 1;
            this.nbItemRow = new int[]{1};
            this.colPos = new int[]{0};
        }
    }

    public ScilabBooleanSparse(int n, int n2, int n3, int[] nArray, int[] nArray2, boolean bl) throws ScilabSparseException {
        this(n, n2, n3, nArray, nArray2);
        if (bl) {
            ScilabSparse.checkValidity(n, n2, n3, nArray, nArray2);
        }
    }

    public ScilabBooleanSparse(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.rows = n;
        this.cols = n2;
        this.nbItem = n3;
        this.nbItemRow = nArray;
        this.colPos = nArray2;
    }

    public ScilabBooleanSparse(boolean[][] blArray) {
        if (blArray.length != 0 && blArray[0].length != 0) {
            int n;
            this.rows = blArray.length;
            this.cols = blArray[0].length;
            this.nbItemRow = new int[this.rows];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < this.rows; ++n) {
                for (int i = 0; i < this.cols; ++i) {
                    if (!blArray[n][i]) continue;
                    ++this.nbItem;
                    int n2 = n;
                    this.nbItemRow[n2] = this.nbItemRow[n2] + 1;
                    arrayList.add(i);
                }
            }
            this.colPos = new int[arrayList.size()];
            n = 0;
            for (Integer n3 : arrayList) {
                this.colPos[n++] = n3;
            }
        }
    }

    public ScilabBooleanSparse(String string, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this(n, n2, n3, nArray, nArray2);
        this.varName = string;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_boolean_sparse;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == 0 && this.cols == 0;
    }

    public int getNbNonNullItems() {
        return this.nbItem;
    }

    public void setNbNonNullItems(int n) {
        this.nbItem = n;
    }

    public int[] getNbItemRow() {
        return this.nbItemRow;
    }

    public void setNbItemRow(int[] nArray) {
        this.nbItemRow = nArray;
    }

    public int[] getScilabColPos() {
        int[] nArray = new int[this.colPos.length];
        for (int i = 0; i < this.colPos.length; ++i) {
            nArray[i] = this.colPos[i] + 1;
        }
        return nArray;
    }

    public int[] getColPos() {
        return this.colPos;
    }

    public void setColPos(int[] nArray) {
        this.colPos = nArray;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return false;
    }

    public boolean[][] getFullMatrix() {
        int n = 0;
        int n2 = 0;
        boolean[][] blArray = new boolean[this.rows][this.cols];
        for (int i = 0; i < this.nbItemRow.length; ++i) {
            while (n2 < n + this.nbItemRow[i]) {
                blArray[i][this.colPos[n2]] = true;
                ++n2;
            }
            n += this.nbItemRow[i];
        }
        return blArray;
    }

    public boolean[] getSerializedBooleanSparseMatrix() {
        return new boolean[0];
    }

    @Override
    public int getHeight() {
        return this.rows;
    }

    @Override
    public int getWidth() {
        return this.cols;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.colPos);
        n = 31 * n + this.cols;
        n = 31 * n + this.nbItem;
        n = 31 * n + Arrays.hashCode(this.nbItemRow);
        n = 31 * n + this.rows;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabBooleanSparse) {
            ScilabBooleanSparse scilabBooleanSparse = (ScilabBooleanSparse)object;
            return this.getNbNonNullItems() == scilabBooleanSparse.getNbNonNullItems() && ScilabSparse.compareNbItemRow(this.getNbItemRow(), scilabBooleanSparse.getNbItemRow()) && Arrays.equals(this.getColPos(), scilabBooleanSparse.getColPos());
        }
        return false;
    }

    @Override
    public Object getSerializedObject() {
        return new Object[]{new int[]{this.rows, this.cols}, this.nbItemRow, this.getScilabColPos()};
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.rows = objectInput.readInt();
                this.cols = objectInput.readInt();
                this.nbItem = objectInput.readInt();
                this.nbItemRow = (int[])objectInput.readObject();
                this.colPos = (int[])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabBooleanSparse with a version " + n + " does not exist");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this.rows);
        objectOutput.writeInt(this.cols);
        objectOutput.writeInt(this.nbItem);
        objectOutput.writeObject(this.nbItemRow);
        objectOutput.writeObject(this.colPos);
        objectOutput.writeObject(this.varName);
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
        stringBuilder.append("sparse([");
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.nbItemRow.length; ++n) {
            while (n2 < n3 + this.nbItemRow[n]) {
                stringBuilder.append(Integer.toString(n + 1));
                stringBuilder.append(", ");
                stringBuilder.append(Integer.toString(this.colPos[n2] + 1));
                if (n2 < this.nbItem - 1) {
                    stringBuilder.append(" ; ");
                }
                ++n2;
            }
            n3 += this.nbItemRow[n];
        }
        stringBuilder.append("], [");
        for (n = 0; n < this.nbItem; ++n) {
            stringBuilder.append("%t");
            if (n >= this.nbItem - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], [");
        stringBuilder.append(Integer.toString(this.rows));
        stringBuilder.append(", ");
        stringBuilder.append(Integer.toString(this.cols));
        stringBuilder.append("])");
        return stringBuilder.toString();
    }
}

