/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.FullBtreeDict;
import com.sun.java.help.search.Schema;
import java.io.IOException;
import java.net.URL;

public class BtreeDictCompactor
extends FullBtreeDict {
    private CompactorDictBlock _currentLeaf;
    private byte[] _lastKey = new byte[255];
    private int _lastKeyLength = 0;
    private int _limit;
    private int _nEntries = 0;
    private int _entry = 0;
    private int _counter = 0;
    private InternalBlockState _parent = null;
    private boolean debug = false;

    public BtreeDictCompactor(BtreeDictParameters params, boolean update) throws Exception {
        this.init(params, update, new BlockFactory(){

            public Block makeBlock() {
                return new CompactorDictBlock();
            }
        });
        this._currentLeaf = new CompactorDictBlock();
        this._currentLeaf.setBlockNumber(this._counter++);
        this._limit = 2038;
        this._entry = this._currentLeaf.firstEntry();
        this.params = params;
    }

    protected CompactorDictBlock accessBlock1(int index) throws Exception {
        return (CompactorDictBlock)this.blockManager.accessBlock(index);
    }

    public void store(byte[] buffer, int keyLen, int id) {
        if (id > 0) {
            int cpr;
            for (cpr = 0; cpr < this._lastKeyLength && this._lastKey[cpr] == buffer[cpr]; ++cpr) {
            }
            int needed = 6 + keyLen - cpr;
            if (this._entry + needed <= this._limit) {
                this._currentLeaf.makeEntry(this._entry, buffer, id, keyLen - cpr, cpr);
                this._entry += needed;
                ++this._nEntries;
                this._lastKeyLength = keyLen;
                System.arraycopy(buffer, cpr, this._lastKey, cpr, keyLen - cpr);
            } else {
                this._currentLeaf.setFree(this._entry);
                this._currentLeaf.setNumberOfEntries(this._nEntries);
                if (this._parent == null) {
                    this._parent = new InternalBlockState(this._currentLeaf.number);
                }
                this._parent.store(buffer, keyLen, id, this.newBlock(this._currentLeaf));
                this._entry = this._currentLeaf.firstEntry();
                this._nEntries = 0;
                this._lastKeyLength = 0;
            }
        }
    }

    private int newBlock(BtreeDict.DictBlock block) {
        int number = this._counter++;
        try {
            this.blockManager.writeBlock(block);
            block.setBlockNumber(number);
            this.blockManager.writeBlock(block);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return number;
    }

    public void close() throws IOException {
        this._currentLeaf.setFree(this._entry);
        this._currentLeaf.setNumberOfEntries(this._nEntries);
        this.blockManager.writeBlock(this._currentLeaf);
        if (this._parent == null) {
            this.debug("root: " + this._currentLeaf.number);
        } else {
            this._parent.close();
        }
        this.blockManager.close();
    }

    public void compact(BtreeDictParameters params) throws Exception {
        BtreeDictCompactor target = new BtreeDictCompactor(params, true);
        ((CompactorDictBlock)this.blockManager.accessBlock(this.root)).doMap1(this, target);
        target.close();
        this.blockManager.close();
    }

    public static void main(String[] args) {
        try {
            Schema schema = new Schema(null, args[0], false);
            BtreeDictParameters params = new BtreeDictParameters(schema, "TMAP");
            BtreeDictCompactor source = new BtreeDictCompactor(params, false);
            URL url = new URL("file", "", args[1]);
            BtreeDictParameters params2 = new BtreeDictParameters(url, 2048, 0, 24);
            source.compact(params2);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("BtreeDictCompactor: " + msg);
        }
    }

    private final class InternalBlockState {
        private CompactorDictBlock _block;
        private byte[] _lastKey = new byte[255];
        private int _lastKeyLength;
        private int _entry;
        private int _nEntries;
        private int _limit;
        private InternalBlockState _parent;

        public InternalBlockState(int leftChild) {
            BtreeDictCompactor.this.debug("NEW ROOT " + BtreeDictCompactor.this._counter);
            BtreeDictCompactor.this.debug(BtreeDictCompactor.this.params.toString());
            BtreeDictCompactor.this.params.setRoot(BtreeDictCompactor.this._counter);
            this._block = new CompactorDictBlock();
            this._block.isLeaf = false;
            this._block.setBlockNumber(BtreeDictCompactor.this._counter++);
            this.init(leftChild);
        }

        private void init(int leftChild) {
            this._entry = this._block.firstEntry();
            this._nEntries = 0;
            this._lastKeyLength = 0;
            this._limit = 2028;
            this._block.setChildIndex(0, leftChild);
        }

        public void store(byte[] buffer, int keyLen, int id, int newBlock) {
            int cpr;
            for (cpr = 0; cpr < this._lastKeyLength && this._lastKey[cpr] == buffer[cpr]; ++cpr) {
            }
            int needed = 6 + keyLen - cpr;
            if (this._entry + needed <= this._limit) {
                this._block.makeEntry(this._entry, buffer, id, keyLen - cpr, cpr);
                this._entry += needed;
                ++this._nEntries;
                this._block.setChildIndex(this._nEntries, newBlock);
                this._limit -= 4;
                this._lastKeyLength = keyLen;
                System.arraycopy(buffer, cpr, this._lastKey, cpr, keyLen - cpr);
            } else {
                BtreeDictCompactor.this.debug("NEW: SPLIT INTERNAL");
                this._block.setFree(this._entry);
                this._block.setNumberOfEntries(this._nEntries);
                if (this._parent == null) {
                    this._parent = new InternalBlockState(this._block.number);
                }
                this._parent.store(buffer, keyLen, id, BtreeDictCompactor.this.newBlock(this._block));
                this.init(newBlock);
            }
        }

        public void close() throws IOException {
            this._block.setFree(this._entry);
            this._block.setNumberOfEntries(this._nEntries);
            BtreeDictCompactor.this.blockManager.writeBlock(this._block);
            if (this._parent == null) {
                BtreeDictCompactor.this.debug("root: " + this._block.number);
            } else {
                this._parent.close();
            }
        }
    }

    private final class CompactorDictBlock
    extends FullBtreeDict.FullDictBlock {
        private CompactorDictBlock() {
            super(BtreeDictCompactor.this);
        }

        private int restoreKey1(int entry, byte[] buffer) {
            int howMany = this.entryKeyLength(entry);
            int where = this.entryCompression(entry);
            int from = this.entryKey(entry);
            while (howMany-- > 0) {
                buffer[where++] = this.data[from++];
            }
            return where;
        }

        protected void doMap1(BtreeDictCompactor owner, BtreeDictCompactor target) throws Exception {
            byte[] buffer = new byte[255];
            int freeSpace = this.free();
            int entry = this.firstEntry();
            if (this.isLeaf) {
                while (entry < freeSpace) {
                    target.store(buffer, this.restoreKey1(entry, buffer), this.entryID(entry));
                    entry = this.nextEntry(entry);
                }
            } else {
                owner.lock(this);
                int entryIndex = 0;
                while (entry < freeSpace) {
                    owner.accessBlock1(this.getChildIdx(entryIndex)).doMap1(owner, target);
                    target.store(buffer, this.restoreKey1(entry, buffer), this.entryID(entry));
                    entry = this.nextEntry(entry);
                    ++entryIndex;
                }
                owner.accessBlock1(this.getChildIdx(entryIndex)).doMap1(owner, target);
                owner.unlock(this);
            }
        }
    }
}

