/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class ScilabDoubleEntry
extends JFormattedTextField
implements XComponent,
XChooser {
    private static final DecimalFormatSymbols FORMAT_SYMBOL = DecimalFormatSymbols.getInstance();
    private static final DecimalFormat SCILAB_FORMAT = new DecimalFormat("0.0####E00", FORMAT_SYMBOL);
    private static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final InputVerifier VALIDATE_POSITIVE_DOUBLE = new InputVerifier(){

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JFormattedTextField jFormattedTextField = (JFormattedTextField)jComponent;
            try {
                BigDecimal bigDecimal = new BigDecimal(jFormattedTextField.getText());
                if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 && bigDecimal.compareTo(MAX_DOUBLE) <= 0) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return bl;
            }
            return bl;
        }
    };

    public ScilabDoubleEntry(Node node) {
        super(SCILAB_FORMAT);
        this.setValue(new BigDecimal(0.0));
        this.setInputVerifier(VALIDATE_POSITIVE_DOUBLE);
        this.refresh(node);
    }

    public final String value() {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    public final void value(String string) {
        try {
            this.setValue(new BigDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public Object choose() {
        return SCILAB_FORMAT.format(this.getValue());
    }

    @Override
    public String[] actuators() {
        String[] stringArray = new String[]{"enable", "value", "editable"};
        return stringArray;
    }

    @Override
    public void refresh(Node node) {
        Object object;
        String string = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string.equals("true"));
        String string2 = XCommonManager.getAttribute(node, "value");
        try {
            object = new BigDecimal(string2);
            BigDecimal bigDecimal = (BigDecimal)this.getValue();
            if (!((BigDecimal)object).equals(bigDecimal)) {
                this.setValue(object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = XConfigManager.getAttribute(node, "editable", "true");
        this.setEditable(((String)object).equals("true"));
    }

    static {
        FORMAT_SYMBOL.setDecimalSeparator('.');
        SCILAB_FORMAT.setDecimalFormatSymbols(FORMAT_SYMBOL);
        SCILAB_FORMAT.setParseIntegerOnly(false);
        SCILAB_FORMAT.setParseBigDecimal(true);
    }
}

