/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.label;

import java.awt.Dimension;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.Camera;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.label.Label;
import org.scilab.modules.graphic_objects.utils.Utils;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.label.LabelPositioner;
import org.scilab.modules.renderer.JoGLView.label.LabelSpriteDrawer;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class LabelManager {
    private final Map<Integer, Texture> textureMap = new ConcurrentHashMap<Integer, Texture>();
    private final TextureManager textureManager;

    public LabelManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public Dimension[] getLabelsSize(ColorMap colorMap, Axes axes, AxesDrawer axesDrawer) {
        Label label = (Label)GraphicController.getController().getObjectFromId(axes.getXAxisLabel());
        Label label2 = (Label)GraphicController.getController().getObjectFromId(axes.getYAxisLabel());
        Label label3 = (Label)GraphicController.getController().getObjectFromId(axes.getTitle());
        Dimension[] dimensionArray = new Dimension[3];
        Label[] labelArray = new Label[]{label, label2, label3};
        LabelPositioner[] labelPositionerArray = new LabelPositioner[]{axesDrawer.getXAxisLabelPositioner(axes), axesDrawer.getYAxisLabelPositioner(axes), axesDrawer.getTitlePositioner(axes)};
        for (int i = 0; i < 3; ++i) {
            if (labelArray[i] != null && !labelArray[i].isEmpty() && labelArray[i].getAutoPosition().booleanValue() && labelArray[i].getAutoRotation().booleanValue()) {
                Texture texture = this.getTexture(colorMap, labelArray[i]);
                dimensionArray[i] = texture.getDataProvider().getTextureSize();
                double d = labelPositionerArray[i].getAutoRotationAngle();
                if (d != 90.0 && d != 270.0) continue;
                int n = dimensionArray[i].width;
                dimensionArray[i].width = dimensionArray[i].height;
                dimensionArray[i].height = n;
                continue;
            }
            dimensionArray[i] = new Dimension();
        }
        return dimensionArray;
    }

    public Dimension getXLabelSize(ColorMap colorMap, Axes axes, AxesDrawer axesDrawer) {
        Label label = (Label)GraphicController.getController().getObjectFromId(axes.getXAxisLabel());
        if (label != null && !label.isEmpty()) {
            Texture texture = this.getTexture(colorMap, label);
            return texture.getDataProvider().getTextureSize();
        }
        return new Dimension();
    }

    public void draw(DrawingTools drawingTools, ColorMap colorMap, Label label, AxesDrawer axesDrawer) throws SciRendererException {
        LabelPositioner labelPositioner;
        boolean bl = true;
        Integer n = label.getIdentifier();
        Integer n2 = label.getParentAxes();
        if (n2 == null) {
            return;
        }
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n2);
        if (axes.getXAxisLabel().equals(label.getIdentifier())) {
            labelPositioner = axesDrawer.getXAxisLabelPositioner(axes);
        } else if (axes.getYAxisLabel().equals(label.getIdentifier())) {
            labelPositioner = axesDrawer.getYAxisLabelPositioner(axes);
        } else if (axes.getZAxisLabel().equals(label.getIdentifier())) {
            labelPositioner = axesDrawer.getZAxisLabelPositioner(axes);
            bl = axes.getViewAsEnum() == Camera.ViewType.VIEW_3D;
        } else if (axes.getTitle().equals(label.getIdentifier())) {
            labelPositioner = axesDrawer.getTitlePositioner(axes);
        } else {
            return;
        }
        drawingTools.getTransformationManager().getModelViewStack().pop();
        this.positionAndDraw(drawingTools, colorMap, label, labelPositioner, axes, axesDrawer, bl);
        drawingTools.getTransformationManager().getModelViewStack().pushRightMultiply(axesDrawer.getDataTransformation());
    }

    public final void positionAndDraw(DrawingTools drawingTools, ColorMap colorMap, Label label, LabelPositioner labelPositioner, Axes axes, AxesDrawer axesDrawer, boolean bl) throws SciRendererException {
        Vector3d vector3d;
        Vector3d vector3d2;
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        Texture texture = this.getTexture(colorMap, label);
        labelPositioner.setLabelTexture(texture);
        labelPositioner.setDrawingTools(drawingTools);
        labelPositioner.setParentAxes(axes);
        labelPositioner.setAutoPosition(label.getAutoPosition());
        labelPositioner.setAutoRotation(label.getAutoRotation());
        labelPositioner.setUserRotationAngle(180.0 * label.getFontAngle() / Math.PI);
        double[][] dArray = axes.getScaleTranslateFactors();
        Vector3d vector3d3 = this.computeUnscaledAxesCoords(new Vector3d(label.getPosition()), dArray);
        vector3d3 = ScaleUtils.applyLogScale(vector3d3, blArray);
        vector3d3 = axesDrawer.getBoxCoordinates(vector3d3);
        labelPositioner.setLabelUserPosition(vector3d3);
        labelPositioner.positionLabel();
        Vector3d vector3d4 = labelPositioner.getAnchorPoint();
        AnchorPosition anchorPosition = labelPositioner.getAnchorPosition();
        if (label.getAutoPosition().booleanValue()) {
            vector3d2 = labelPositioner.getLowerLeftCornerPosition();
            vector3d = axesDrawer.getObjectCoordinates(vector3d2);
            vector3d = ScaleUtils.applyInverseLogScale(vector3d, blArray);
            vector3d = this.computeScaledAxesCoords(vector3d, dArray);
            label.setPosition(new Double[]{vector3d.getX(), vector3d.getY(), vector3d.getZ()});
            label.setAutoPosition(Boolean.valueOf(true));
        }
        vector3d2 = axesDrawer.getProjection();
        vector3d = labelPositioner.getProjCorners();
        Vector3d[] vector3dArray = this.computeCorners((Transformation)vector3d2, (Vector3d[])vector3d, axes);
        Double[] doubleArray = this.cornersToCoordinateArray(vector3dArray);
        label.setCorners(doubleArray);
        double d = 0.0;
        if (label.getAutoRotation().booleanValue()) {
            d = labelPositioner.getRotationAngle();
            label.setFontAngle(Double.valueOf(Math.PI * d / 180.0));
            label.setAutoRotation(Boolean.valueOf(true));
        } else {
            d = labelPositioner.getUserRotationAngle();
        }
        d = -d;
        if (label.getVisible().booleanValue() && bl && Utils.isValid((double)vector3d4.getX(), (double)vector3d4.getY(), (double)vector3d4.getZ()) && Utils.isValid((double)d)) {
            if (labelPositioner.getUseWindowCoordinates()) {
                Transformation transformation = drawingTools.getTransformationManager().getCanvasProjection();
                Vector3d vector3d5 = transformation.project(vector3d4);
                vector3d5 = new Vector3d((double)Math.round(vector3d5.getX()), (double)Math.round(vector3d5.getY()), (double)Math.round(vector3d5.getZ()));
                drawingTools.getTransformationManager().useWindowCoordinate();
                drawingTools.draw(texture, anchorPosition, vector3d5, d);
                drawingTools.getTransformationManager().useSceneCoordinate();
            } else {
                drawingTools.draw(texture, anchorPosition, vector3d4, d);
            }
        }
    }

    private Vector3d computeScaledAxesCoords(Vector3d vector3d, double[][] dArray) {
        double[] dArray2 = vector3d.getData();
        dArray2[0] = (dArray2[0] - dArray[1][0]) / dArray[0][0];
        dArray2[1] = (dArray2[1] - dArray[1][1]) / dArray[0][1];
        dArray2[2] = (dArray2[2] - dArray[1][2]) / dArray[0][2];
        return new Vector3d(dArray2);
    }

    private Vector3d computeUnscaledAxesCoords(Vector3d vector3d, double[][] dArray) {
        double[] dArray2 = vector3d.getData();
        dArray2[0] = dArray2[0] * dArray[0][0] + dArray[1][0];
        dArray2[1] = dArray2[1] * dArray[0][1] + dArray[1][1];
        dArray2[2] = dArray2[2] * dArray[0][2] + dArray[1][2];
        return new Vector3d(dArray2);
    }

    private Vector3d[] computeCorners(Transformation transformation, Vector3d[] vector3dArray, Axes axes) {
        Vector3d[] vector3dArray2 = new Vector3d[4];
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        double[][] dArray = axes.getScaleTranslateFactors();
        vector3dArray2[0] = transformation.unproject(vector3dArray[0]);
        vector3dArray2[1] = transformation.unproject(vector3dArray[1]);
        vector3dArray2[2] = transformation.unproject(vector3dArray[2]);
        vector3dArray2[3] = transformation.unproject(vector3dArray[3]);
        vector3dArray2[0] = ScaleUtils.applyInverseLogScale(vector3dArray2[0], blArray);
        vector3dArray2[1] = ScaleUtils.applyInverseLogScale(vector3dArray2[1], blArray);
        vector3dArray2[2] = ScaleUtils.applyInverseLogScale(vector3dArray2[2], blArray);
        vector3dArray2[3] = ScaleUtils.applyInverseLogScale(vector3dArray2[3], blArray);
        vector3dArray2[0] = this.computeScaledAxesCoords(vector3dArray2[0], dArray);
        vector3dArray2[1] = this.computeScaledAxesCoords(vector3dArray2[1], dArray);
        vector3dArray2[2] = this.computeScaledAxesCoords(vector3dArray2[2], dArray);
        vector3dArray2[3] = this.computeScaledAxesCoords(vector3dArray2[3], dArray);
        return vector3dArray2;
    }

    private Double[] cornersToCoordinateArray(Vector3d[] vector3dArray) {
        Double[] doubleArray = new Double[]{vector3dArray[0].getX(), vector3dArray[0].getY(), vector3dArray[0].getZ(), vector3dArray[2].getX(), vector3dArray[2].getY(), vector3dArray[2].getZ(), vector3dArray[3].getX(), vector3dArray[3].getY(), vector3dArray[3].getZ(), vector3dArray[1].getX(), vector3dArray[1].getY(), vector3dArray[1].getZ()};
        return doubleArray;
    }

    public void update(Integer n, int n2) {
        if (80 != n2 && 231 != n2 && 230 != n2 && 233 != n2) {
            this.dispose(n);
        }
    }

    public Texture getTexture(ColorMap colorMap, Label label) {
        Texture texture = this.textureMap.get(label.getIdentifier());
        if (texture == null) {
            texture = this.createSprite(colorMap, label);
            this.textureMap.put(label.getIdentifier(), texture);
        }
        return texture;
    }

    private Texture createSprite(ColorMap colorMap, Label label) {
        LabelSpriteDrawer labelSpriteDrawer = new LabelSpriteDrawer(colorMap, label);
        Texture texture = this.textureManager.createTexture();
        texture.setMagnificationFilter(Texture.Filter.LINEAR);
        texture.setMinifyingFilter(Texture.Filter.LINEAR);
        texture.setDrawer((TextureDrawer)labelSpriteDrawer);
        return texture;
    }

    public void dispose(Integer n) {
        Texture texture = this.textureMap.get(n);
        if (texture != null) {
            this.textureManager.dispose(texture);
            this.textureMap.remove(n);
        }
    }

    public void disposeAll() {
        this.textureManager.dispose(this.textureMap.values());
        this.textureMap.clear();
    }
}

