/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.contouredObject;

import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.renderer.JoGLView.DataManager;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.mark.MarkSpriteManager;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

public class ContouredObjectDrawer {
    private final DrawerVisitor visitor;
    private final DataManager dataManager;
    private final MarkSpriteManager markManager;

    public ContouredObjectDrawer(DrawerVisitor drawerVisitor, DataManager dataManager, MarkSpriteManager markSpriteManager) {
        this.visitor = drawerVisitor;
        this.dataManager = dataManager;
        this.markManager = markSpriteManager;
    }

    public void draw(ContouredObject contouredObject, boolean bl) throws SciRendererException, ObjectRemovedException, OutOfMemoryException {
        DrawingTools drawingTools = this.visitor.getDrawingTools();
        ColorMap colorMap = this.visitor.getColorMap();
        Integer n = contouredObject.getIdentifier();
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setVertices(this.dataManager.getVertexBuffer(n));
        defaultGeometry.setIndices(this.dataManager.getIndexBuffer(n));
        defaultGeometry.setWireIndices(this.dataManager.getWireIndexBuffer(n));
        defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
        Appearance appearance = new Appearance();
        if (contouredObject.getFillMode().booleanValue()) {
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
            appearance.setFillColor(ColorFactory.createColor(colorMap, contouredObject.getBackground()));
        } else {
            defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
        }
        if (contouredObject.getLineMode().booleanValue()) {
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
            appearance.setLineColor(ColorFactory.createColor(colorMap, contouredObject.getLineColor()));
            appearance.setLinePattern(contouredObject.getLineStyleAsEnum().asPattern());
            appearance.setLineWidth(contouredObject.getLineThickness().floatValue());
        } else {
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.NONE);
        }
        if (!bl) {
            defaultGeometry.setPolygonOffsetMode(true);
        }
        drawingTools.draw((Geometry)defaultGeometry, appearance);
        if (contouredObject.getMarkMode().booleanValue()) {
            Texture texture = this.markManager.getMarkSprite(contouredObject, colorMap, appearance);
            ElementsBuffer elementsBuffer = this.dataManager.getVertexBuffer(contouredObject.getIdentifier());
            drawingTools.draw(texture, AnchorPosition.CENTER, elementsBuffer);
        }
    }
}

