/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.UI_data;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class CreateNewVariableAction
extends CommonCallBack {
    private static final String KEY = "OSSCKEY N";
    private static final String CREATENEW = "Create new";
    private static final int GAP = 5;
    private final SwingScilabVariableEditor editor;

    private CreateNewVariableAction(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        super(string);
        this.editor = swingScilabVariableEditor;
    }

    public static void registerAction(SwingScilabVariableEditor swingScilabVariableEditor, JTable jTable) {
        jTable.getActionMap().put(CREATENEW, (Action)((Object)new CreateNewVariableAction(swingScilabVariableEditor, CREATENEW)));
        jTable.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), CREATENEW);
    }

    public void callBack() {
        JTable jTable = this.editor.getCurrentTable();
        Object[] objectArray = this.askForNewMatrix();
        if (!((String)objectArray[0]).isEmpty()) {
            SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
            String string = SwingEditvarTableModel.getDataAsScilabString((String)objectArray[3]);
            if (string.isEmpty()) {
                string = "0";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("L$8625083632641564277=warning(\"query\");warning(\"off\");");
            stringBuilder.append("if execstr(\"");
            stringBuilder.append((String)objectArray[0]);
            stringBuilder.append("=");
            stringBuilder.append("repmat(");
            stringBuilder.append(string);
            stringBuilder.append(",");
            stringBuilder.append(((Integer)objectArray[1]).toString());
            stringBuilder.append(",");
            stringBuilder.append(((Integer)objectArray[2]).toString());
            stringBuilder.append(");editvar(\"\"");
            stringBuilder.append((String)objectArray[0]);
            stringBuilder.append("\"\")\",\"errcatch\") <> 0 then messagebox(\"Could not create variable: \" + lasterror() + \"\"");
            stringBuilder.append(",\"Variable editor\",\"error\",\"modal\");");
            stringBuilder.append("end;");
            stringBuilder.append("warning(L$8625083632641564277);clear(\"L$8625083632641564277\");");
            stringBuilder.append("updatebrowsevar()");
            swingEditvarTableModel.execCommand(stringBuilder.toString());
        }
    }

    public Object[] askForNewMatrix() {
        final JDialog jDialog = new JDialog();
        final Object[] objectArray = new Object[]{"", new Integer(0), new Integer(0), ""};
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"rrze_table", (String)"256x256")).getImage());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(UiDataMessages.VARNAME);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField(25);
        jTextField.setText(UI_data.getUnnamedVariable());
        jTextField.selectAll();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jTextField, gridBagConstraints);
        JLabel jLabel2 = new JLabel(UiDataMessages.NUMROWS);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        final JSpinner jSpinner = new JSpinner();
        ((SpinnerNumberModel)jSpinner.getModel()).setMinimum(new Comparable<Integer>(){

            @Override
            public int compareTo(Integer n) {
                return -n.intValue();
            }
        });
        jSpinner.setValue(0);
        ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().setColumns(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jSpinner, gridBagConstraints);
        JLabel jLabel3 = new JLabel(UiDataMessages.NUMCOLS);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        final JSpinner jSpinner2 = new JSpinner();
        ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Comparable<Integer>(){

            @Override
            public int compareTo(Integer n) {
                return -n.intValue();
            }
        });
        jSpinner2.setValue(0);
        ((JSpinner.DefaultEditor)jSpinner2.getEditor()).getTextField().setColumns(6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jSpinner2, gridBagConstraints);
        JLabel jLabel4 = new JLabel(UiDataMessages.FILLWITH);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        final JTextField jTextField2 = new JTextField(15);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        JButton jButton = new JButton(UiDataMessages.CANCEL);
        JButton jButton2 = new JButton(UiDataMessages.OK);
        JPanel jPanel2 = new JPanel();
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jDialog.setContentPane(jPanel);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                objectArray[0] = jTextField.getText();
                objectArray[1] = jSpinner.getValue();
                objectArray[2] = jSpinner2.getValue();
                objectArray[3] = jTextField2.getText();
            }
        });
        jDialog.setTitle(UiDataMessages.CREATENEWVAR);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo((Component)((Object)this.editor));
        jDialog.setVisible(true);
        return objectArray;
    }

    public static JButton createButton(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new CreateNewVariableAction(swingScilabVariableEditor, string)));
        jButton.setToolTipText(string);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"variable-new"));
        jButton.setIcon(imageIcon);
        return jButton;
    }

    public static MenuItem createMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new CreateNewVariableAction(swingScilabVariableEditor, string));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(ScilabKeyStroke.getKeyStroke((String)KEY));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        return (SwingScilabMenuItem)CreateNewVariableAction.createMenuItem(swingScilabVariableEditor, string).getAsSimpleMenuItem();
    }
}

