/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.ui_data.filebrowser.FileNode;
import org.scilab.modules.ui_data.filebrowser.ScilabFileBrowserModel;

public class FileBrowserRowSorter
extends RowSorter<TableModel> {
    private JTree tree;
    private JTable table;
    private List<RowSorter.SortKey> sortKeys;

    public FileBrowserRowSorter(JTree jTree, JTable jTable) {
        this.tree = jTree;
        this.table = jTable;
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public int convertRowIndexToModel(int n) {
        return n;
    }

    @Override
    public int convertRowIndexToView(int n) {
        return n;
    }

    @Override
    public TableModel getModel() {
        return this.table.getModel();
    }

    @Override
    public int getModelRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public List<RowSorter.SortKey> getSortKeys() {
        if (this.sortKeys == null) {
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.setSortKeys(arrayList);
        }
        return this.sortKeys;
    }

    @Override
    public int getViewRowCount() {
        return this.getModelRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void rowsDeleted(int n, int n2) {
    }

    @Override
    public void rowsInserted(int n, int n2) {
    }

    @Override
    public void rowsUpdated(int n, int n2) {
    }

    @Override
    public void rowsUpdated(int n, int n2, int n3) {
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> list) {
        this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(list));
        this.fireSortOrderChanged();
    }

    @Override
    public void toggleSortOrder(int n) {
        Object object;
        SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, this.table).setCursor(Cursor.getPredefinedCursor(3));
        ScilabFileBrowserModel scilabFileBrowserModel = (ScilabFileBrowserModel)this.tree.getModel();
        FileNode fileNode = (FileNode)scilabFileBrowserModel.getRoot();
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(new TreePath(fileNode));
        fileNode.toggleSortOrder(this.table.getColumnName(n));
        fileNode.orderFiles();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            object = (FileNode)this.tree.getPathForRow(i).getLastPathComponent();
            ((FileNode)object).orderFiles();
        }
        scilabFileBrowserModel.fireTreeStructureChanged(scilabFileBrowserModel, new TreePath(fileNode).getPath(), null, null);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.tree.expandPath(enumeration.nextElement());
            }
        }
        SortOrder sortOrder = fileNode.getOrder();
        object = new ArrayList();
        object.add(new RowSorter.SortKey(n, sortOrder));
        this.setSortKeys((List<? extends RowSorter.SortKey>)object);
        this.table.repaint();
        SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, this.table).setCursor(Cursor.getPredefinedCursor(0));
    }
}

