/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.io;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.io.mxObjectCodec;
import java.util.HashSet;
import java.util.Map;
import org.scilab.modules.graph.io.ScilabBooleanCodec;
import org.scilab.modules.graph.io.ScilabDoubleCodec;
import org.scilab.modules.graph.io.ScilabIntegerCodec;
import org.scilab.modules.graph.io.ScilabListCodec;
import org.scilab.modules.graph.io.ScilabStringCodec;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabString;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ScilabObjectCodec
extends mxObjectCodec {
    protected static final String HEIGHT = "height";
    protected static final String WIDTH = "width";
    protected static final String COLUMN = "column";
    protected static final String LINE = "line";
    protected static final String DATA = "data";
    protected static final String POSITION = "position";
    protected static final String BINARY = "binary";
    protected static boolean binary;
    protected static ScilabList binaryObjects;
    protected static final Object LOCK;

    public ScilabObjectCodec(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        super(object, stringArray, stringArray2, map);
        HashSet<String> hashSet = new HashSet<String>(this.exclude);
        hashSet.add("type");
        this.exclude = hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object enableBinarySerialization(ScilabList scilabList) {
        Object object = LOCK;
        synchronized (object) {
            binary = true;
            binaryObjects = scilabList == null ? new ScilabList() : scilabList;
            return LOCK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScilabList disableBinarySerialization() {
        Object object = LOCK;
        synchronized (object) {
            binary = false;
            ScilabList scilabList = binaryObjects;
            binaryObjects = null;
            return scilabList;
        }
    }

    public static ScilabList getBinaryObjects() {
        return binaryObjects;
    }

    public static void register() {
        ScilabStringCodec scilabStringCodec = new ScilabStringCodec(new ScilabString(), null, null, null);
        mxCodecRegistry.register((mxObjectCodec)scilabStringCodec);
        ScilabBooleanCodec scilabBooleanCodec = new ScilabBooleanCodec(new ScilabBoolean(), null, null, null);
        mxCodecRegistry.register((mxObjectCodec)scilabBooleanCodec);
        ScilabDoubleCodec scilabDoubleCodec = new ScilabDoubleCodec(new ScilabDouble(), null, null, null);
        mxCodecRegistry.register((mxObjectCodec)scilabDoubleCodec);
        ScilabIntegerCodec scilabIntegerCodec = new ScilabIntegerCodec(new ScilabInteger(), null, null, null);
        mxCodecRegistry.register((mxObjectCodec)scilabIntegerCodec);
        ScilabListCodec scilabListCodec = new ScilabListCodec(new ScilabList(), new String[]{"scilabClass"}, null, null);
        mxCodecRegistry.register((mxObjectCodec)scilabListCodec);
    }

    protected int getIntegerAttribute(NamedNodeMap namedNodeMap, String string) throws UnrecognizeFormatException {
        int n;
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            throw new UnrecognizeFormatException();
        }
        try {
            n = Integer.parseInt(node.getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnrecognizeFormatException(numberFormatException);
        }
        return n;
    }

    protected boolean getBooleanAttribute(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return false;
        }
        return Boolean.parseBoolean(node.getNodeValue());
    }

    protected int getHeight(NamedNodeMap namedNodeMap) throws UnrecognizeFormatException {
        return this.getIntegerAttribute(namedNodeMap, HEIGHT);
    }

    protected int getWidth(NamedNodeMap namedNodeMap) throws UnrecognizeFormatException {
        return this.getIntegerAttribute(namedNodeMap, WIDTH);
    }

    protected int getColumnIndex(NamedNodeMap namedNodeMap) throws UnrecognizeFormatException {
        return this.getIntegerAttribute(namedNodeMap, COLUMN);
    }

    protected int getLineIndex(NamedNodeMap namedNodeMap) throws UnrecognizeFormatException {
        return this.getIntegerAttribute(namedNodeMap, LINE);
    }

    static {
        LOCK = new Object();
    }

    public static class UnrecognizeFormatException
    extends Exception {
        public UnrecognizeFormatException() {
        }

        public UnrecognizeFormatException(Exception exception) {
            super(exception);
        }
    }
}

