/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;
import org.scilab.modules.xcos.utils.XcosRouteUtils;

public class XcosRoute {
    private List<mxPoint> listRoute = new ArrayList<mxPoint>(0);
    private boolean lockPortPosition = false;

    public List<mxPoint> getList() {
        return this.listRoute;
    }

    public void updateRoute(BasicLink basicLink, Object[] objectArray, XcosDiagram xcosDiagram) {
        this.lockPortPosition = false;
        this.updateRoute(basicLink, objectArray, xcosDiagram, this.lockPortPosition);
    }

    public void updateRoute(BasicLink basicLink, Object[] objectArray, XcosDiagram xcosDiagram, boolean bl) {
        this.lockPortPosition = bl;
        mxICell mxICell2 = basicLink.getSource();
        mxICell mxICell3 = basicLink.getTarget();
        Object[] objectArray2 = this.getAllOtherCells(objectArray, new Object[]{basicLink, mxICell2, mxICell3});
        if (mxICell2 != null && mxICell3 != null) {
            boolean bl2 = this.computeRoute(mxICell2, mxICell3, objectArray2, xcosDiagram);
            if (bl2) {
                List<mxPoint> list = this.getNonRedundantPoints();
                mxGeometry mxGeometry2 = new mxGeometry();
                mxGeometry2.setPoints(list);
                ((mxGraphModel)xcosDiagram.getModel()).setGeometry((Object)basicLink, mxGeometry2);
                this.listRoute.clear();
            } else if (!bl) {
                // empty if block
            }
        }
    }

    protected boolean computeRoute(mxICell mxICell2, mxICell mxICell3, Object[] objectArray, XcosDiagram xcosDiagram) {
        boolean bl;
        BasicPort basicPort;
        this.listRoute.clear();
        if (!(mxICell2 instanceof BasicPort) || !(mxICell3 instanceof BasicPort)) {
            return false;
        }
        Orientation orientation = null;
        Orientation orientation2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        mxCellState mxCellState2 = xcosDiagram.getView().getState((Object)mxICell2);
        if (mxCellState2 != null) {
            d = mxCellState2.getCenterX();
            d2 = mxCellState2.getCenterY();
            basicPort = (BasicPort)mxICell2;
            orientation = this.getPortRelativeOrientation(basicPort, xcosDiagram);
        }
        if ((mxCellState2 = xcosDiagram.getView().getState((Object)mxICell3)) != null) {
            d3 = mxCellState2.getCenterX();
            d4 = mxCellState2.getCenterY();
            basicPort = (BasicPort)mxICell3;
            orientation2 = this.getPortRelativeOrientation(basicPort, xcosDiagram);
        }
        if (mxICell2.getParent() instanceof SplitBlock) {
            d = mxICell2.getParent().getGeometry().getCenterX();
            d2 = mxICell2.getParent().getGeometry().getCenterY();
        }
        if (mxICell3.getParent() instanceof SplitBlock) {
            d3 = mxICell3.getParent().getGeometry().getCenterX();
            d4 = mxICell3.getParent().getGeometry().getCenterY();
        }
        boolean bl2 = bl = mxICell2.getParent() instanceof SplitBlock && mxICell3.getParent() instanceof SplitBlock;
        if (XcosRouteUtils.isPointCoincident(d, d2, d3, d4, bl)) {
            return true;
        }
        if (XcosRouteUtils.isStrictlyAligned(d, d2, d3, d4) && !XcosRouteUtils.checkObstacle(d, d2, d3, d4, objectArray) && !XcosRouteUtils.isOrientationParallel(d, d2, d3, d4, orientation, orientation2)) {
            return true;
        }
        if (mxICell2.getParent() instanceof SplitBlock) {
            orientation = this.lockPortPosition ? ((BasicPort)mxICell2).getOrientation() : this.getNewOrientation(mxICell2, d, d2, mxICell3, d3, d4, xcosDiagram);
        }
        if (mxICell3.getParent() instanceof SplitBlock) {
            orientation2 = this.lockPortPosition ? ((BasicPort)mxICell3).getOrientation() : this.getNewOrientation(mxICell3, d3, d4, mxICell2, d, d2, xcosDiagram);
        }
        mxPoint mxPoint2 = this.getPointAwayPort(mxICell2, d, d2, orientation, objectArray, xcosDiagram);
        mxPoint mxPoint3 = this.getPointAwayPort(mxICell3, d3, d4, orientation2, objectArray, xcosDiagram);
        objectArray = Arrays.copyOf(objectArray, objectArray.length + 2);
        objectArray[objectArray.length - 2] = mxICell2;
        objectArray[objectArray.length - 1] = mxICell3;
        List<mxPoint> list = XcosRouteUtils.getSimpleRoute(mxPoint2, orientation, mxPoint3, orientation2, objectArray);
        if (list != null && list.size() > 0) {
            this.listRoute.addAll(list);
            return true;
        }
        list = XcosRouteUtils.getComplexRoute(mxPoint2, orientation, mxPoint3, orientation2, objectArray, 3);
        if (list != null && list.size() > 0) {
            this.listRoute.addAll(list);
            return true;
        }
        return false;
    }

    protected List<mxPoint> getNonRedundantPoints() {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(0);
        if (this.listRoute.size() > 2) {
            arrayList.add(this.listRoute.get(0));
            for (int i = 1; i < this.listRoute.size() - 1; ++i) {
                mxPoint mxPoint2 = (mxPoint)arrayList.get(arrayList.size() - 1);
                mxPoint mxPoint3 = this.listRoute.get(i);
                mxPoint mxPoint4 = this.listRoute.get(i + 1);
                if (XcosRouteUtils.pointInLineSegment(mxPoint3.getX(), mxPoint3.getY(), mxPoint2.getX(), mxPoint2.getY(), mxPoint4.getX(), mxPoint4.getY())) continue;
                arrayList.add(mxPoint3);
            }
            arrayList.add(this.listRoute.get(this.listRoute.size() - 1));
        } else {
            arrayList.addAll(this.listRoute);
        }
        return arrayList;
    }

    private mxPoint getPointAwayPort(mxICell mxICell2, double d, double d2, Orientation orientation, Object[] objectArray, XcosDiagram xcosDiagram) {
        mxPoint mxPoint2 = new mxPoint(d, d2);
        double d3 = 40.0;
        if (mxICell2.getParent() instanceof SplitBlock) {
            d3 = 15.0;
        }
        switch (orientation) {
            case EAST: {
                mxPoint2.setX(mxPoint2.getX() + d3);
                while (Math.abs(mxPoint2.getX() - d) > 10.0 && (XcosRouteUtils.checkObstacle(d, d2, mxPoint2.getX(), mxPoint2.getY(), objectArray) || XcosRouteUtils.checkPointInBlocks(mxPoint2.getX(), mxPoint2.getY(), objectArray))) {
                    mxPoint2.setX(mxPoint2.getX() - 10.0);
                }
                break;
            }
            case SOUTH: {
                mxPoint2.setY(mxPoint2.getY() + d3);
                while (Math.abs(mxPoint2.getY() - d2) > 10.0 && (XcosRouteUtils.checkObstacle(d, d2, mxPoint2.getX(), mxPoint2.getY(), objectArray) || XcosRouteUtils.checkPointInBlocks(mxPoint2.getX(), mxPoint2.getY(), objectArray))) {
                    mxPoint2.setY(mxPoint2.getY() - 10.0);
                }
                break;
            }
            case WEST: {
                mxPoint2.setX(mxPoint2.getX() - d3);
                while (Math.abs(mxPoint2.getX() - d) > 10.0 && (XcosRouteUtils.checkObstacle(d, d2, mxPoint2.getX(), mxPoint2.getY(), objectArray) || XcosRouteUtils.checkPointInBlocks(mxPoint2.getX(), mxPoint2.getY(), objectArray))) {
                    mxPoint2.setX(mxPoint2.getX() + 10.0);
                }
                break;
            }
            case NORTH: {
                mxPoint2.setY(mxPoint2.getY() - d3);
                while (Math.abs(mxPoint2.getY() - d2) > 10.0 && (XcosRouteUtils.checkObstacle(d, d2, mxPoint2.getX(), mxPoint2.getY(), objectArray) || XcosRouteUtils.checkPointInBlocks(mxPoint2.getX(), mxPoint2.getY(), objectArray))) {
                    mxPoint2.setY(mxPoint2.getY() + 10.0);
                }
                break;
            }
        }
        return mxPoint2;
    }

    private Orientation getPortRelativeOrientation(BasicPort basicPort, XcosDiagram xcosDiagram) {
        double d = xcosDiagram.getView().getState((Object)basicPort).getCenterX();
        double d2 = xcosDiagram.getView().getState((Object)basicPort).getCenterY();
        mxICell mxICell2 = basicPort.getParent();
        double d3 = xcosDiagram.getView().getState((Object)mxICell2).getCenterX();
        double d4 = xcosDiagram.getView().getState((Object)mxICell2).getCenterY();
        double d5 = mxICell2.getGeometry().getWidth();
        double d6 = mxICell2.getGeometry().getHeight();
        d -= d3;
        d2 -= d4;
        Orientation orientation = basicPort.getOrientation();
        if (d >= d5 * Math.abs(d2) / d6) {
            orientation = Orientation.EAST;
        } else if (d2 >= d6 * Math.abs(d) / d5) {
            orientation = Orientation.SOUTH;
        } else if (d <= -d5 * Math.abs(d2) / d6) {
            orientation = Orientation.WEST;
        } else if (d2 <= -d6 * Math.abs(d) / d5) {
            orientation = Orientation.NORTH;
        }
        return orientation;
    }

    private Orientation getNewOrientation(mxICell mxICell2, double d, double d2, mxICell mxICell3, double d3, double d4, XcosDiagram xcosDiagram) {
        Orientation orientation = Orientation.EAST;
        if (mxICell2.getParent() instanceof SplitBlock) {
            SplitBlock splitBlock = (SplitBlock)mxICell2.getParent();
            Orientation orientation2 = this.getSplitBlockInputOrientation(splitBlock, xcosDiagram);
            if (mxICell2 instanceof InputPort || mxICell2 instanceof ControlPort) {
                orientation = orientation2;
            } else if (mxICell2 instanceof OutputPort || mxICell2 instanceof CommandPort) {
                BasicPort basicPort = (BasicPort)mxICell2;
                BasicPort basicPort2 = null;
                basicPort2 = basicPort == splitBlock.getOut1() ? splitBlock.getOut2() : splitBlock.getOut1();
                mxICell mxICell4 = basicPort2.getEdgeAt(0);
                if (mxICell4 instanceof BasicLink) {
                    mxICell mxICell5 = ((BasicLink)mxICell4).getTarget();
                    mxPoint mxPoint2 = this.getCenterPoint(mxICell5, xcosDiagram);
                    double d5 = mxPoint2.getX();
                    double d6 = mxPoint2.getY();
                    double d7 = d - d5;
                    double d8 = d2 - d6;
                    double d9 = d3 - d5;
                    double d10 = d4 - d6;
                    double d11 = d7 * d10 - d9 * d8;
                    if (d3 >= d && d4 <= d2) {
                        orientation = d11 >= 0.0 && orientation2 != Orientation.NORTH ? Orientation.NORTH : (orientation2 != Orientation.EAST ? Orientation.EAST : Orientation.NORTH);
                    } else if (d3 >= d && d4 >= d2) {
                        orientation = d11 >= 0.0 && orientation2 != Orientation.EAST ? Orientation.EAST : (orientation2 != Orientation.SOUTH ? Orientation.SOUTH : Orientation.EAST);
                    } else if (d3 <= d && d4 <= d2) {
                        orientation = d11 >= 0.0 && orientation2 != Orientation.WEST ? Orientation.WEST : (orientation2 != Orientation.NORTH ? Orientation.NORTH : Orientation.WEST);
                    } else if (d3 <= d && d4 >= d2) {
                        orientation = d11 >= 0.0 && orientation2 != Orientation.SOUTH ? Orientation.SOUTH : (orientation2 != Orientation.WEST ? Orientation.WEST : Orientation.SOUTH);
                    }
                }
            }
        }
        return orientation;
    }

    private Orientation getSplitBlockInputOrientation(SplitBlock splitBlock, XcosDiagram xcosDiagram) {
        double d;
        double d2;
        Orientation orientation = Orientation.EAST;
        BasicPort basicPort = splitBlock.getIn();
        double d3 = splitBlock.getGeometry().getCenterX();
        double d4 = splitBlock.getGeometry().getCenterY();
        mxICell mxICell2 = basicPort.getEdgeAt(0);
        double d5 = 0.0;
        double d6 = 0.0;
        if (mxICell2 instanceof BasicLink) {
            mxICell mxICell3 = ((BasicLink)mxICell2).getSource();
            mxPoint mxPoint2 = this.getCenterPoint(mxICell3, xcosDiagram);
            d5 = mxPoint2.getX();
            d6 = mxPoint2.getY();
        }
        if ((d2 = d5 - d3) >= Math.abs(d = d6 - d4)) {
            orientation = Orientation.EAST;
        } else if (d >= Math.abs(d2)) {
            orientation = Orientation.SOUTH;
        } else if (d2 <= -Math.abs(d)) {
            orientation = Orientation.WEST;
        } else if (d <= -Math.abs(d2)) {
            orientation = Orientation.NORTH;
        }
        return orientation;
    }

    private mxPoint getCenterPoint(mxICell mxICell2, XcosDiagram xcosDiagram) {
        mxPoint mxPoint2 = new mxPoint(0.0, 0.0);
        if (mxICell2 instanceof BasicPort) {
            BasicPort basicPort = (BasicPort)mxICell2;
            mxICell mxICell3 = basicPort.getParent();
            if (mxICell3 instanceof SplitBlock) {
                mxPoint2.setX(mxICell3.getGeometry().getCenterX());
                mxPoint2.setY(mxICell3.getGeometry().getCenterY());
            } else {
                mxCellState mxCellState2 = xcosDiagram.getView().getState((Object)mxICell2);
                if (mxCellState2 != null) {
                    mxPoint2.setX(mxCellState2.getCenterX());
                    mxPoint2.setY(mxCellState2.getCenterY());
                }
            }
        } else if (mxICell2 instanceof BasicBlock) {
            BasicBlock basicBlock = (BasicBlock)mxICell2;
            mxPoint2.setX(basicBlock.getGeometry().getCenterX());
            mxPoint2.setY(basicBlock.getGeometry().getCenterY());
        }
        return mxPoint2;
    }

    protected Object[] getAllOtherCells(Object[] objectArray, Object ... objectArray2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(0);
        arrayList.addAll(Arrays.asList(objectArray2));
        for (Object object : objectArray2) {
            if (!(object instanceof BasicLink)) continue;
            BasicLink object2 = (BasicLink)((Object)object);
            if (object2.getSource() != null && object2.getSource().getParent() instanceof SplitBlock) {
                arrayList.add(object2.getSource().getParent());
            }
            if (object2.getTarget() == null || !(object2.getTarget().getParent() instanceof SplitBlock)) continue;
            arrayList.add(object2.getTarget().getParent());
        }
        ArrayList arrayList2 = new ArrayList(0);
        for (Object object : objectArray) {
            if (arrayList.contains(object) || object instanceof SplitBlock) continue;
            if (!arrayList2.contains(object)) {
                arrayList2.add(object);
            }
            if (!(object instanceof BasicBlock)) continue;
            BasicBlock basicBlock = (BasicBlock)object;
            for (int i = 0; i < basicBlock.getChildCount(); ++i) {
                if (arrayList.contains(basicBlock.getChildAt(i))) continue;
                arrayList2.add(basicBlock.getChildAt(i));
            }
        }
        Object[] objectArray3 = arrayList2.toArray();
        return objectArray3;
    }
}

