/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public class NavigationAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static final String ICON_NEXT = FindIconHelper.findIcon((String)"go-next");
    private static final String ICON_PREV = FindIconHelper.findIcon((String)"go-previous");
    private static JButton btnNEXT;
    private static JButton btnPREV;
    private static MenuItem miNEXT;
    private static MenuItem miPREV;

    public NavigationAction() {
        super("");
    }

    public static JButton createButtonNext() {
        btnNEXT = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)btnNEXT);
        btnNEXT.setName(XcosMessages.NEXT);
        btnNEXT.setIcon(new ImageIcon(ICON_NEXT));
        btnNEXT.setToolTipText(XcosMessages.NEXT);
        btnNEXT.addActionListener((ActionListener)NavigationAction.getCallBack());
        btnNEXT.setFocusable(true);
        NavigationAction.setEnabledNext(false);
        return btnNEXT;
    }

    public static JButton createButtonPrev() {
        btnPREV = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)btnPREV);
        btnPREV.setName(XcosMessages.PREVIOUS);
        btnPREV.setIcon(new ImageIcon(ICON_PREV));
        btnPREV.setToolTipText(XcosMessages.PREVIOUS);
        btnPREV.addActionListener((ActionListener)NavigationAction.getCallBack());
        btnPREV.setFocusable(true);
        NavigationAction.setEnabledPrev(false);
        return btnPREV;
    }

    public static MenuItem createMenuNext() {
        miNEXT = ScilabMenuItem.createMenuItem();
        miNEXT.setText(XcosMessages.NEXT);
        miNEXT.setMnemonic('N');
        miNEXT.setCallback(NavigationAction.getCallBack());
        ((SwingScilabMenuItem)miNEXT.getAsSimpleMenuItem()).setIcon((Icon)new ImageIcon(ICON_NEXT));
        return miNEXT;
    }

    public static MenuItem createMenuPrev() {
        miPREV = ScilabMenuItem.createMenuItem();
        miPREV.setText(XcosMessages.PREVIOUS);
        miPREV.setMnemonic('P');
        miPREV.setCallback(NavigationAction.getCallBack());
        ((SwingScilabMenuItem)miPREV.getAsSimpleMenuItem()).setIcon((Icon)new ImageIcon(ICON_PREV));
        return miPREV;
    }

    private static CommonCallBack getCallBack() {
        CommonCallBack commonCallBack = null;
        try {
            commonCallBack = (CommonCallBack)NavigationAction.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return commonCallBack;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.isEmpty()) {
            string = ((JButton)actionEvent.getSource()).getName();
        }
        if (string.equals(XcosMessages.NEXT)) {
            PaletteManagerView.get().getPanel().goNext();
        } else if (string.equals(XcosMessages.PREVIOUS)) {
            PaletteManagerView.get().getPanel().goPrevious();
        }
    }

    public static void setEnabledNext(boolean bl) {
        btnNEXT.setEnabled(bl);
        miNEXT.setEnabled(bl);
    }

    public static void setEnabledPrev(boolean bl) {
        btnPREV.setEnabled(bl);
        miPREV.setEnabled(bl);
    }

    public void callBack() {
    }
}

