/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxICell;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BlockGraphicElement;
import org.scilab.modules.xcos.io.scicos.BlockModelElement;
import org.scilab.modules.xcos.io.scicos.InputPortElement;
import org.scilab.modules.xcos.io.scicos.OutputPortElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public final class BlockElement
extends AbstractElement<BasicBlock> {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("Block", "graphics", "model", "gui", "doc");
    private static final int INTERFUNCTION_INDEX = DATA_FIELD_NAMES.indexOf("gui");
    private ScilabMList data;
    private final XcosDiagram diag;
    private final BlockModelElement modelElement;
    private final BlockGraphicElement graphicElement;
    private int ordering;
    private HashMap<Long, Integer> orderingMap;

    public BlockElement(JavaController javaController, XcosDiagram xcosDiagram) {
        super(javaController);
        this.diag = xcosDiagram;
        this.modelElement = new BlockModelElement(javaController, xcosDiagram);
        this.graphicElement = new BlockGraphicElement(javaController, xcosDiagram);
        this.ordering = 0;
        this.orderingMap = new HashMap();
    }

    @Override
    public BasicBlock decode(ScilabType scilabType, BasicBlock basicBlock) throws ScicosFormatException {
        int n;
        Object object;
        this.data = (ScilabMList)scilabType;
        BasicBlock basicBlock2 = basicBlock;
        this.validate();
        String string = ((ScilabString)this.data.get(INTERFUNCTION_INDEX)).getData()[0][0];
        if (basicBlock2 == null) {
            object = XcosCellFactory.lookForInterfunction(string);
            basicBlock2 = XcosCellFactory.createBlock(this.controller, object, string, this.controller.createObject(Kind.BLOCK), Kind.BLOCK);
        }
        object = new long[]{0L};
        if (this.diag.getKind() == Kind.BLOCK) {
            this.controller.getObjectProperty(this.diag.getUID(), this.diag.getKind(), ObjectProperties.PARENT_DIAGRAM, (long[])object);
            this.controller.setObjectProperty(basicBlock2.getUID(), basicBlock2.getKind(), ObjectProperties.PARENT_BLOCK, this.diag.getUID());
        }
        this.controller.setObjectProperty(basicBlock2.getUID(), basicBlock2.getKind(), ObjectProperties.PARENT_DIAGRAM, (long)object[0]);
        basicBlock2 = this.beforeDecode(scilabType, basicBlock2);
        InputPortElement inputPortElement = new InputPortElement(this.controller, (ScilabType)this.data);
        int n2 = inputPortElement.getNumberOfInputPort();
        for (int i = 0; i < n2; ++i) {
            InputPort inputPort = inputPortElement.decode((ScilabType)this.data, null);
            basicBlock2.insert((mxICell)inputPort, i);
        }
        OutputPortElement outputPortElement = new OutputPortElement(this.controller, (ScilabType)this.data);
        int n3 = outputPortElement.getNumberOfOutputPort();
        for (n = 0; n < n3; ++n) {
            OutputPort outputPort = outputPortElement.decode((ScilabType)this.data, null);
            basicBlock2.insert((mxICell)outputPort, n2 + n);
        }
        n = 1;
        this.graphicElement.decode((ScilabType)this.data.get(n), basicBlock2);
        this.modelElement.decode((ScilabType)this.data.get(++n), basicBlock2);
        ++n;
        this.controller.setObjectProperty(basicBlock2.getUID(), basicBlock2.getKind(), ObjectProperties.INTERFACE_FUNCTION, string);
        this.fillDocStructure((ScilabType)this.data.get(++n), basicBlock2);
        this.orderingMap.put(basicBlock2.getUID(), this.ordering++);
        basicBlock2 = this.afterDecode(scilabType, basicBlock2);
        return basicBlock2;
    }

    private void fillDocStructure(ScilabType scilabType, BasicBlock basicBlock) {
        String string;
        if (scilabType instanceof ScilabDouble) {
            return;
        }
        ScilabList scilabList = (ScilabList)scilabType;
        if (scilabList.size() > 0 && scilabList.get(0) instanceof ScilabString && this.isValidUid(string = ((ScilabString)scilabList.get(0)).getData()[0][0])) {
            basicBlock.setId(string);
            return;
        }
    }

    private boolean isValidUid(String string) {
        boolean bl;
        String[] stringArray = string.split(":");
        boolean bl2 = bl = stringArray.length == 3;
        if (bl) {
            try {
                Integer.parseInt(stringArray[0], 16);
                Long.parseLong(stringArray[1], 16);
                Integer.parseInt(stringArray[2], 16);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        }
        return bl;
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabMList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabMList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabList) && !BlockElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

