/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.sax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.HandledElementsCategory;
import org.scilab.modules.xcos.io.sax.BlockHandler;
import org.scilab.modules.xcos.io.sax.CustomHandler;
import org.scilab.modules.xcos.io.sax.JGraphXHandler;
import org.scilab.modules.xcos.io.sax.LinkHandler;
import org.scilab.modules.xcos.io.sax.PortHandler;
import org.scilab.modules.xcos.io.sax.RawDataHandler;
import org.scilab.modules.xcos.io.sax.ScilabHandler;
import org.scilab.modules.xcos.utils.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XcosSAXHandler
extends DefaultHandler {
    protected static final Logger LOG = Logger.getLogger("org.scilab.modules.xcos.io.sax");
    protected final XcosDiagram root;
    protected final ScilabList dictionary;
    protected final JavaController controller;
    protected final Map<String, HandledElement> elementMap;
    protected final Pattern validCIdentifier;
    private final Map<HandledElementsCategory, ScilabHandler> handlers;
    Stack<Object> parents = new Stack();
    Stack<HashMap<String, Long>> allChildren = new Stack();
    HashMap<String, ArrayList<UnresolvedReference>> unresolvedReferences = new HashMap();

    XcosCell lookupForParentXcosCellElement() {
        Optional<XcosCell> optional = this.parents.stream().filter(object -> object instanceof XcosCell).map(object -> (XcosCell)((Object)((Object)object))).findFirst();
        return optional.orElse(null);
    }

    public XcosSAXHandler(XcosDiagram xcosDiagram, ScilabList scilabList) {
        this.root = xcosDiagram;
        this.dictionary = scilabList;
        this.controller = new JavaController();
        this.elementMap = HandledElement.getMap();
        this.validCIdentifier = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]+");
        EnumMap<HandledElementsCategory, ScilabHandler> enumMap = new EnumMap<HandledElementsCategory, ScilabHandler>(HandledElementsCategory.class);
        enumMap.put(HandledElementsCategory.JGRAPHX, new JGraphXHandler(this));
        enumMap.put(HandledElementsCategory.BLOCK, new BlockHandler(this));
        enumMap.put(HandledElementsCategory.LINK, new LinkHandler(this));
        enumMap.put(HandledElementsCategory.PORT, new PortHandler(this));
        enumMap.put(HandledElementsCategory.RAW_DATA, new RawDataHandler(this));
        enumMap.put(HandledElementsCategory.CUSTOM, new CustomHandler(this));
        this.handlers = Collections.unmodifiableMap(enumMap);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        if (LOG.isLoggable(Level.FINEST)) {
            object2 = new char[this.parents.size()];
            Arrays.fill((char[])object2, ' ');
            object = new StringBuilder();
            if (attributes.getValue("id") != null) {
                ((StringBuilder)object).append(" id=\"").append(attributes.getValue("id")).append("\"");
            } else if (attributes.getValue("as") != null) {
                ((StringBuilder)object).append(" as=\"").append(attributes.getValue("as")).append("\"");
            }
            LOG.finest((char[])object2 + string2 + (CharSequence)object);
        }
        object2 = (Object)this.elementMap.get(string2);
        object = null;
        if (object2 != null) {
            object = this.handlers.get((Object)((HandledElement)((Object)object2)).getCategory()).startElement((HandledElement)((Object)object2), attributes);
        }
        this.parents.push(object);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        HandledElement handledElement = this.elementMap.get(string2);
        if (handledElement != null) {
            this.handlers.get((Object)handledElement.getCategory()).endElement(handledElement);
        }
        this.parents.pop();
    }

    protected void insertChild(XcosCell xcosCell) {
        Kind kind;
        long l;
        XcosCell xcosCell2 = this.lookupForParentXcosCellElement();
        if (Kind.BLOCK.equals((Object)xcosCell2.getKind())) {
            l = xcosCell2.getUID();
            kind = xcosCell2.getKind();
            this.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_BLOCK, l);
        } else {
            l = ((XcosCell)((Object)this.root.getDefaultParent())).getUID();
            kind = Kind.DIAGRAM;
        }
        this.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.PARENT_DIAGRAM, ((XcosCell)((Object)this.root.getDefaultParent())).getUID());
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        this.controller.getObjectProperty(l, kind, ObjectProperties.CHILDREN, vectorOfScicosID);
        vectorOfScicosID.add(xcosCell.getUID());
        this.controller.setObjectProperty(l, kind, ObjectProperties.CHILDREN, vectorOfScicosID);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.err.println("XcosSAXHandler warning: " + sAXParseException.getSystemId() + " at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber());
        System.err.println(sAXParseException.getMessage());
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("XcosSAXHandler error: " + sAXParseException.getSystemId() + " at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber());
        System.err.println(sAXParseException.getMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("XcosSAXHandler fatalError: " + sAXParseException.getSystemId() + " at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber());
        System.err.println(sAXParseException.getMessage());
    }

    protected static class UnresolvedReference {
        private final ScicosObjectOwner owner;
        private final ObjectProperties property;
        private final ObjectProperties associatedProperty;
        private final int associatedPropertyIndex;

        public UnresolvedReference(ScicosObjectOwner scicosObjectOwner, ObjectProperties objectProperties, ObjectProperties objectProperties2, int n) {
            this.owner = scicosObjectOwner;
            this.property = objectProperties;
            this.associatedProperty = objectProperties2;
            this.associatedPropertyIndex = n;
        }

        public void resolve(JavaController javaController, long l, Kind kind) {
            javaController.setObjectProperty(this.owner.getUID(), this.owner.getKind(), this.property, l);
            if (this.associatedProperty != null) {
                VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                javaController.getObjectProperty(l, kind, this.associatedProperty, vectorOfScicosID);
                vectorOfScicosID.resize(Math.max(vectorOfScicosID.size(), this.associatedPropertyIndex + 1));
                vectorOfScicosID.set(this.associatedPropertyIndex, this.owner.getUID());
                javaController.setObjectProperty(l, kind, this.associatedProperty, vectorOfScicosID);
            }
        }
    }
}

