/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.actions.DebugLevelAction;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.utils.XcosMessages;

public class DebugLevelDialog
extends JDialog {
    private final ScicosParameters parameters;
    private JList debugList;

    public DebugLevelDialog(Component component, ScicosParameters scicosParameters) {
        this.parameters = scicosParameters;
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
        Image image = imageIcon.getImage();
        this.setLayout(new GridBagLayout());
        this.setIconImage(image);
        this.setTitle(XcosMessages.SET_DEBUG);
        this.setModal(true);
        this.setLocationRelativeTo(component);
        this.setDefaultCloseOperation(2);
        ScilabSwingUtilities.closeOnEscape((Window)this);
        this.initComponents();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel(XcosMessages.DEBUG_LEVEL_LABEL);
        this.debugList = new JList<DebugLevelAction.DebugLevel>(DebugLevelAction.DebugLevel.values());
        this.debugList.setSelectedIndex(this.parameters.getDebugLevel(new JavaController()));
        this.debugList.setSelectionMode(0);
        JButton jButton = new JButton(XcosMessages.CANCEL);
        JButton jButton2 = new JButton(XcosMessages.OK);
        jButton2.setPreferredSize(jButton.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.debugList, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        this.add((Component)jPanel, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugLevelDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((DebugLevelAction.DebugLevel)((Object)DebugLevelDialog.this.debugList.getSelectedValue())).getValue();
                try {
                    DebugLevelDialog.this.parameters.setDebugLevel(new JavaController(), n);
                    ScilabInterpreterManagement.synchronousScilabExec((String)"scicos_debug", (Object[])new Object[]{n});
                    DebugLevelDialog.this.dispose();
                }
                catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                    Logger.getLogger(DebugLevelAction.class.getName()).severe(interpreterException.toString());
                }
                catch (PropertyVetoException propertyVetoException) {
                    Logger.getLogger(DebugLevelAction.class.getName()).severe(propertyVetoException.toString());
                }
            }
        });
    }
}

