/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import com.mxgraph.swing.mxGraphComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class PrintAction
extends DefaultAction {
    public static final String NAME = XcosMessages.PRINT;
    public static final String SMALL_ICON = "document-print";
    public static final int MNEMONIC_KEY = 80;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int DEFAULT_MARGIN = 36;

    public PrintAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return PrintAction.createMenu((ScilabGraph)scilabGraph, PrintAction.class);
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return PrintAction.createButton((ScilabGraph)scilabGraph, PrintAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        mxGraphComponent mxGraphComponent2 = this.getGraph(null).getAsComponent();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.printDialog()) {
            PageFormat pageFormat = mxGraphComponent2.getPageFormat();
            Paper paper = new Paper();
            double d = 36.0;
            paper.setImageableArea(d, d, paper.getWidth() - d * 2.0, paper.getHeight() - d * 2.0);
            pageFormat.setPaper(paper);
            printerJob.setPrintable((Printable)mxGraphComponent2, pageFormat);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException);
            }
        }
    }
}

