/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.actions.RecentFileAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class OpenAction
extends DefaultAction {
    private static final long serialVersionUID = -8765712033802048782L;
    private String initialDirectoryPath;

    public OpenAction(String string, SciNotes sciNotes) {
        this(string, sciNotes, "");
    }

    public OpenAction(String string, SciNotes sciNotes, String string2) {
        super(string, sciNotes);
        this.initialDirectoryPath = string2;
    }

    @Override
    public void doAction() {
        String string = this.initialDirectoryPath.length() == 0 ? this.getEditor().getTextPane().getName() : this.initialDirectoryPath;
        if (string == null) {
            string = ConfigManager.getLastOpenedDirectory();
        }
        String[] stringArray = new String[]{"*.sci", "*.sce", "*.tst", "*.start", "*.quit", "*.dem", "*.sci|*.sce"};
        FileChooser fileChooser = ScilabFileChooser.createFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addMask(stringArray, null);
        fileChooser.setMultipleSelection(true);
        fileChooser.setInitialDirectory(string);
        fileChooser.setTitle(SciNotesMessages.OPEN);
        fileChooser.setUiDialogType(0);
        fileChooser.displayAndWait();
        fileChooser.invalidate();
        String[] stringArray2 = fileChooser.getSelection();
        if (stringArray2.length > 0 && stringArray2[0] != "") {
            for (int i = 0; i < stringArray2.length; ++i) {
                ConfigSciNotesManager.saveToRecentOpenedFiles(stringArray2[i]);
                this.getEditor().readFile(new File(stringArray2[i]));
            }
            RecentFileAction.updateRecentOpenedFilesMenu(this.getEditor());
        }
    }

    public static Object createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return OpenAction.createMenu(string, null, new OpenAction(string, sciNotes), keyStroke);
    }

    public static JButton createButton(String string, String string2, SciNotes sciNotes) {
        return OpenAction.createButton(string, string2, (ActionListener)((Object)new OpenAction(string, sciNotes)));
    }
}

