/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabContext;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.TabManager;

public class ScilabView
extends WrappedPlainView {
    public static final int TABVERTICAL = 0;
    public static final int TABDOUBLECHEVRONS = 1;
    public static final int TABHORIZONTAL = 2;
    public static final int TABCHARACTER = 3;
    public static final int TABNOTHING = 4;
    private static final String DESKTOPHINTS = "awt.font.desktophints";
    private ScilabContext context;
    private ScilabLexer lexer;
    private ScilabDocument doc;
    private Segment text = new Segment();
    private boolean isTabViewable = true;
    private boolean isWhiteViewable = true;
    private boolean enable;
    private int tabType;
    private String tabCharacter;
    private int tabLength;
    private int numOfColumns;
    private Color lineColor;
    private final Rectangle rect;
    private Map desktopFontHints;
    private boolean enableDesktopFontHints;
    private int whiteHeight;
    private int whiteWidth;
    private boolean unselected;

    ScilabView(Element element, ScilabContext scilabContext) {
        super(element);
        this.enable = SciNotesOptions.getSciNotesDisplay().keywordsColorization;
        this.tabCharacter = " ";
        this.tabLength = 4;
        this.numOfColumns = 80;
        this.lineColor = new Color(220, 220, 220);
        this.rect = new Rectangle();
        this.enableDesktopFontHints = true;
        this.unselected = true;
        this.context = scilabContext;
        this.doc = (ScilabDocument)this.getDocument();
        if (this.doc.getBinary()) {
            this.disable();
        }
        this.doc.setView(this);
        this.lexer = this.doc.createLexer();
        this.setTabRepresentation(0);
    }

    public void setTabViewable(boolean bl) {
        this.isTabViewable = bl;
    }

    public void setWhiteViewable(boolean bl) {
        this.isWhiteViewable = bl;
    }

    public void disable() {
        this.enable = false;
    }

    public void enable() {
        this.enable = true;
    }

    public void enable(boolean bl) {
        this.enable = bl;
    }

    public void setMaxColumns(int n) {
        this.numOfColumns = n;
    }

    public int getWhiteWidth() {
        return this.whiteWidth;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        if (this.numOfColumns > 0) {
            graphics.setColor(this.lineColor);
            graphics.drawLine(this.numOfColumns * this.whiteWidth, 0, this.numOfColumns * this.whiteWidth, this.getHeight());
        }
        super.paint(graphics, shape);
    }

    @Override
    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle = (Rectangle)super.modelToView(n, bias, n2, bias2, shape);
        rectangle.width = ((Rectangle)shape).width;
        return rectangle;
    }

    public int getLineAllocation(int n) {
        this.rect.setLocation(0, 4);
        try {
            this.childAllocation(n, this.rect);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.rect.y;
    }

    public void reinitialize() {
        this.desktopFontHints = null;
        this.enableDesktopFontHints = true;
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        if (!this.enable) {
            return super.drawUnselectedText(graphics, n, n2, n3, n4);
        }
        if (this.enableDesktopFontHints && this.desktopFontHints == null) {
            this.desktopFontHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty(DESKTOPHINTS);
            this.calculateHeight(((Graphics2D)graphics).getFontRenderContext(), this.context.tokenFonts[0]);
            boolean bl = this.enableDesktopFontHints = this.desktopFontHints != null;
        }
        if (this.enableDesktopFontHints) {
            ((Graphics2D)graphics).addRenderingHints(this.desktopFontHints);
        }
        Element element = this.doc.getDefaultRootElement();
        Element element2 = element.getElement(element.getElementIndex(n3));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = -1;
        int n6 = -1;
        int n7 = n3;
        int n8 = n3;
        int n9 = n;
        int n10 = n2;
        boolean bl = false;
        int n11 = element2.getStartOffset();
        int n12 = element2.getEndOffset();
        if (n11 != n8) {
            try {
                this.lexer.setRange(n11, n12);
                while (n11 < n8) {
                    n6 = this.lexer.scan();
                    n11 = this.lexer.start + this.lexer.yychar() + this.lexer.yylength();
                }
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.lexer.setRange(n8, n12);
        }
        while (n8 < n4 && n6 != 35) {
            try {
                if (!bl) {
                    n6 = this.lexer.scan();
                } else {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n8 = this.lexer.start + this.lexer.yychar();
            int n13 = Math.min(n4, n8 + this.lexer.yylength());
            if (n13 != n7) {
                int n14;
                if (n6 != n5) {
                    if (this.unselected) {
                        graphics.setColor(this.context.tokenColors[n6]);
                    } else {
                        graphics.setColor(Color.WHITE);
                    }
                    graphics.setFont(this.context.tokenFonts[n6]);
                    n5 = n6;
                }
                this.doc.getText(n7, n13 - n7, this.text);
                if ((this.context.tokenAttrib[n6] & 1) != 0) {
                    n14 = Utilities.getTabbedTextWidth(this.text, fontMetrics, n9, (TabExpander)this, n7);
                    graphics.drawLine(n9, n10 + 1, n9 + n14, n10 + 1);
                }
                if ((this.context.tokenAttrib[n6] & 2) != 0) {
                    n14 = Utilities.getTabbedTextWidth(this.text, fontMetrics, n9, (TabExpander)this, n7);
                    graphics.drawLine(n9, n10 - this.whiteHeight, n9 + n14, n10 - this.whiteHeight);
                }
                switch (n6) {
                    case 22: 
                    case 28: 
                    case 30: {
                        if (!this.isWhiteViewable) break;
                        n14 = Utilities.getTabbedTextWidth(this.text, graphics.getFontMetrics(), n9, (TabExpander)this, n7);
                        graphics.drawLine(n9 + (n14 - 1) / 2, n10 - this.whiteHeight, n9 + (n14 + 1) / 2, n10 - this.whiteHeight);
                        break;
                    }
                    case 23: 
                    case 29: 
                    case 31: {
                        if (!this.isTabViewable) break;
                        this.paintTab(this.text, n9, n10, graphics, n7);
                        break;
                    }
                    case 33: {
                        int n15;
                        if (this.unselected) {
                            graphics.setColor(Color.RED);
                        } else {
                            graphics.setColor(Color.WHITE);
                        }
                        n14 = Utilities.getTabbedTextWidth(this.text, graphics.getFontMetrics(), n9, (TabExpander)this, n7);
                        for (n15 = 0; n15 < n14; n15 += 4) {
                            graphics.drawLine(n9 + n15, n10 + 2, n9 + n15 + 1, n10 + 2);
                        }
                        for (n15 = 2; n15 < n14; n15 += 4) {
                            graphics.drawLine(n9 + n15, n10 + 1, n9 + n15 + 1, n10 + 1);
                        }
                        break;
                    }
                }
                n9 = Utilities.drawTabbedText(this.text, n9, n10, graphics, (TabExpander)this, n7);
                n7 = n13;
            }
            n8 = n13;
        }
        return n9;
    }

    @Override
    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        ScilabEditorPane scilabEditorPane = (ScilabEditorPane)this.getContainer();
        int n5 = scilabEditorPane.getSelectionStart();
        int n6 = scilabEditorPane.getSelectionEnd();
        int[] nArray = scilabEditorPane.isNearColumnSelection(n);
        n2 = Math.min(this.doc.getLength(), n2);
        try {
            if (n5 == n6) {
                if (nArray == null) {
                    this.drawUnselectedText(graphics, n3, n4, n, n2);
                    return;
                }
                n5 = nArray[0];
                n6 = nArray[1];
                if (n5 == n6) {
                    this.drawUnselectedText(graphics, n3, n4, n, n2);
                    return;
                }
            }
            if (n >= n5 && n <= n6 && n2 >= n5 && n2 <= n6) {
                this.drawSelectedText(graphics, n3, n4, n, n2);
            } else if (n5 >= n && n5 <= n2) {
                if (n6 >= n && n6 <= n2) {
                    n3 = this.drawUnselectedText(graphics, n3, n4, n, n5);
                    n3 = this.drawSelectedText(graphics, n3, n4, n5, n6);
                    this.drawUnselectedText(graphics, n3, n4, n6, n2);
                } else {
                    n3 = this.drawUnselectedText(graphics, n3, n4, n, n5);
                    this.drawSelectedText(graphics, n3, n4, n5, n2);
                }
            } else if (n6 >= n && n6 <= n2) {
                n3 = this.drawSelectedText(graphics, n3, n4, n, n6);
                this.drawUnselectedText(graphics, n3, n4, n6, n2);
            } else {
                this.drawUnselectedText(graphics, n3, n4, n, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.unselected = false;
        int n5 = this.drawUnselectedText(graphics, n, n2, n3, n4);
        this.unselected = true;
        return n5;
    }

    public void setTabRepresentation(int n) {
        this.tabType = n;
    }

    public void setTabRepresentation(char c) {
        this.setTabRepresentation(3);
        this.tabCharacter = Character.toString(c);
    }

    public void setTabRepresentation(TabManager.Tabulation tabulation) {
        if (tabulation.type == 3) {
            this.setTabRepresentation(tabulation.rep);
        } else {
            this.setTabRepresentation(tabulation.type);
        }
        this.tabLength = tabulation.number;
    }

    public void setDefaultTabRepresentation() {
        this.setTabRepresentation(new TabManager.Tabulation());
    }

    protected void paintTab(Segment segment, int n, int n2, Graphics graphics, int n3) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = Utilities.getTabbedTextWidth(segment, fontMetrics, n, (TabExpander)this, n3);
        switch (this.tabType) {
            case 0: {
                graphics.drawLine(n, n2 + 4, n, n2 + 4 - fontMetrics.getHeight());
                break;
            }
            case 1: {
                graphics.drawString("\u00bb", n, n2);
                break;
            }
            case 2: {
                graphics.drawLine(n, n2 - this.whiteHeight, n + n4 - 1, n2 - this.whiteHeight);
                break;
            }
            case 3: {
                graphics.drawString(this.tabCharacter, n, n2);
                break;
            }
        }
    }

    private void calculateHeight(FontRenderContext fontRenderContext, Font font) {
        TextLayout textLayout = new TextLayout("+", font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        this.whiteHeight = (int)Math.round(-rectangle2D.getY() / 2.0);
        textLayout = new TextLayout("w", font, fontRenderContext);
        rectangle2D = textLayout.getBounds();
        this.whiteWidth = (int)Math.round(rectangle2D.getWidth());
    }
}

