/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.DockingState;
import org.flexdock.event.EventManager;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.event.RegistrationEvent;
import org.flexdock.perspective.restore.handlers.AlreadyRestoredHandler;
import org.flexdock.perspective.restore.handlers.DockPathHandler;
import org.flexdock.perspective.restore.handlers.FloatingHandler;
import org.flexdock.perspective.restore.handlers.MinimizedHandler;
import org.flexdock.perspective.restore.handlers.PointHandler;
import org.flexdock.perspective.restore.handlers.RelativeHandler;
import org.flexdock.perspective.restore.handlers.RestorationHandler;
import org.flexdock.perspective.restore.handlers.UnknownStateHandler;
import org.flexdock.util.RootWindow;

public class RestorationManager {
    private static final RestorationManager SINGLETON = new RestorationManager();
    private Vector restorationHandlers = new Vector();

    private RestorationManager() {
    }

    public static RestorationManager getInstance() {
        return SINGLETON;
    }

    public void addHandler(RestorationHandler handler) {
        if (handler != null) {
            this.restorationHandlers.add(handler);
            EventManager.dispatch(new RegistrationEvent((Object)handler, (Object)this, true));
        }
    }

    public boolean removeHandler(RestorationHandler handler) {
        boolean ret = false;
        if (handler != null && (ret = this.restorationHandlers.remove(handler))) {
            EventManager.dispatch(new RegistrationEvent((Object)handler, (Object)this, false));
        }
        return ret;
    }

    public boolean restore(Dockable dockable) {
        if (dockable != null) {
            DockingState info = PerspectiveManager.getInstance().getDockingState(dockable, true);
            HashMap context = new HashMap();
            for (RestorationHandler handler : this.restorationHandlers) {
                if (!handler.restore(dockable, info, context)) continue;
                return true;
            }
        }
        return false;
    }

    public static RootWindow getRestoreWindow(Dockable dockable) {
        RootWindow[] windows = DockingManager.getDockingWindows();
        return windows.length == 0 ? null : windows[0];
    }

    public static Component getRestoreContainer(Dockable dockable) {
        RootWindow window = RestorationManager.getRestoreWindow(dockable);
        return window == null ? null : window.getRootContainer();
    }

    static {
        RestorationManager.getInstance().addHandler(new AlreadyRestoredHandler());
        RestorationManager.getInstance().addHandler(new FloatingHandler());
        RestorationManager.getInstance().addHandler(new MinimizedHandler());
        RestorationManager.getInstance().addHandler(new RelativeHandler());
        RestorationManager.getInstance().addHandler(new DockPathHandler());
        RestorationManager.getInstance().addHandler(new PointHandler());
        RestorationManager.getInstance().addHandler(new UnknownStateHandler());
    }
}

