/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui;

import com.l2fprod.gui.SkinWindow;
import com.l2fprod.gui.SkinWindowList;
import com.l2fprod.gui.WindowManager;
import com.l2fprod.gui.sound.NoSoundComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyVetoException;
import javax.swing.UIManager;

public class DefaultWindowManager
extends WindowManager {
    public static final String SHADE_BOUNDS_PROPERTY = "windowshadeBounds";
    static final String PREVIOUS_BOUNDS_PROPERTY = "windowpreviousBounds";
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int FASTER_DRAG_MODE = 2;
    private static SkinWindow currentActiveWindow = null;
    int dragMode = 0;
    private transient Rectangle currentBounds = null;
    private transient Point currentLoc = null;
    private transient Graphics desktopGraphics = null;
    private transient Rectangle desktopBounds = null;
    private transient Rectangle[] floatingItems = new Rectangle[0];
    private transient Window ghostWindow = null;

    public void setBoundsForWindow(Container f, int newX, int newY, int newWidth, int newHeight) {
        Dimension dim = f.getSize();
        boolean didResize = dim.width != newWidth || dim.height != newHeight;
        f.setBounds(newX, newY, newWidth, newHeight);
        if (didResize) {
            f.validate();
        }
    }

    public void openWindow(SkinWindow f) {
    }

    public void closeWindow(SkinWindow f) {
        this.removeIconFor(f);
        if (this.getPreviousBounds(f) != null) {
            this.setPreviousBounds(f, null);
        }
        if (this.wasIcon(f)) {
            this.setWasIcon(f, null);
        }
        SkinWindowList.getSkinWindowList().unregisterWindow(f);
    }

    public void maximizeWindow(SkinWindow f) {
        Dimension newSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle p = new Rectangle(0, 0, newSize.width, newSize.height);
        if (!f.isIcon()) {
            this.setPreviousBounds(f, f.getBounds());
        } else {
            try {
                f.setIcon(false);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
        }
        this.setBoundsForWindow(f, 0, 0, p.width, p.height);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e2) {
            // empty catch block
        }
        this.removeIconFor(f);
    }

    public void minimizeWindow(SkinWindow f) {
        if (this.getPreviousBounds(f) != null) {
            Rectangle r = this.getPreviousBounds(f);
            this.setPreviousBounds(f, null);
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
            if (f.isIcon()) {
                try {
                    f.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.setBoundsForWindow(f, r.x, r.y, r.width, r.height);
        }
        this.removeIconFor(f);
    }

    public void shadeWindow(SkinWindow w) {
    }

    public void unshadeWindow(SkinWindow w) {
    }

    public void iconifyWindow(SkinWindow f) {
        boolean findNext = f.isSelected();
        try {
            f.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        f.setVisible(false);
        if (findNext) {
            SkinWindowList.getSkinWindowList().activateNextWindow(f);
        }
    }

    public void deiconifyWindow(SkinWindow f) {
        f.setVisible(true);
        f.toFront();
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void activateWindow(SkinWindow f) {
        if (currentActiveWindow == null) {
            currentActiveWindow = f;
        } else if (currentActiveWindow != f) {
            if (currentActiveWindow.isSelected()) {
                try {
                    currentActiveWindow.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            currentActiveWindow = f;
        }
        f.toFront();
    }

    public void deactivateWindow(SkinWindow f) {
        if (currentActiveWindow == f) {
            currentActiveWindow = null;
        }
    }

    public void beginDraggingWindow(SkinWindow w) {
        this.setupDragMode(w);
        this.currentLoc = w.getLocation();
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setBounds(w.getBounds());
        }
        w.isDragging = true;
    }

    public void dragWindow(SkinWindow w, int newX, int newY) {
        this.currentLoc.x = newX;
        this.currentLoc.y = newY;
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setVisible(true);
            this.ghostWindow.toFront();
            ((Component)this.ghostWindow).setLocation(this.currentLoc.x, this.currentLoc.y);
        } else {
            ((Component)w).setLocation(this.currentLoc.x, this.currentLoc.y);
        }
    }

    public void endDraggingWindow(SkinWindow w) {
        w.isDragging = false;
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setVisible(false);
        }
        if (this.currentLoc != null) {
            ((Component)w).setLocation(this.currentLoc.x, this.currentLoc.y);
            this.currentLoc = null;
        }
    }

    public void beginResizingWindow(SkinWindow w, int direction) {
        this.setupDragMode(w);
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setBounds(w.getBounds());
            ((Component)this.ghostWindow).setVisible(true);
            this.ghostWindow.toFront();
        }
        w.isDragging = true;
    }

    public void resizeWindow(SkinWindow w, int newX, int newY, int newWidth, int newHeight) {
        this.currentBounds = new Rectangle(newX, newY, newWidth, newHeight);
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setBounds(newX, newY, newWidth, newHeight);
        } else {
            this.setBoundsForWindow(w, newX, newY, newWidth, newHeight);
        }
    }

    public void endResizingWindow(SkinWindow w) {
        w.isDragging = false;
        if (this.dragMode == 2) {
            ((Component)this.ghostWindow).setVisible(false);
            this.ghostWindow = null;
        }
        if (this.currentBounds != null) {
            this.setBoundsForWindow(w, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    protected void setPreviousBounds(SkinWindow f, Rectangle r) {
        if (r != null) {
            f.putClientProperty(PREVIOUS_BOUNDS_PROPERTY, r);
        }
    }

    protected void setWasIcon(SkinWindow f, Boolean value) {
        if (value != null) {
            f.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, value);
        }
    }

    protected Rectangle getBoundsForIconOf(SkinWindow f) {
        return null;
    }

    protected Rectangle getPreviousBounds(SkinWindow f) {
        return (Rectangle)f.getClientProperty(PREVIOUS_BOUNDS_PROPERTY);
    }

    protected void removeIconFor(SkinWindow f) {
    }

    protected boolean wasIcon(SkinWindow f) {
        return f.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    private final void setupDragMode(SkinWindow f) {
        String mode = (String)f.getClientProperty("Window.dragMode");
        if (mode != null && mode.equals("faster")) {
            this.dragMode = 2;
            if (this.ghostWindow == null) {
                this.ghostWindow = new NoEventWindow(new Frame("GhostWindow"));
            }
        } else {
            this.dragMode = 0;
        }
    }

    class NoEventWindow
    extends Window
    implements NoSoundComponent {
        public void paint(Graphics g) {
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }

        public NoEventWindow(Frame f) {
            super(f);
            this.disableEvents(64L);
            ((Component)this).setBackground(UIManager.getColor("Panel.background"));
            this.setForeground(UIManager.getColor("Panel.foreground"));
        }
    }
}

