/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public final class Helpers {
    public static final boolean IS_WINDOWS = File.pathSeparatorChar == ';';

    private Helpers() {
    }

    public static String reason(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            return throwable.getClass().getName();
        }
        return string;
    }

    public static void escapeXML(String string, PrintWriter printWriter) {
        char[] cArray = string.toCharArray();
        Helpers.escapeXML(cArray, 0, cArray.length, printWriter);
    }

    public static void escapeXML(char[] cArray, int n, int n2, PrintWriter printWriter) {
        int n3 = n + n2;
        block7: for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\'': {
                    printWriter.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    printWriter.write("&quot;");
                    continue block7;
                }
                case '<': {
                    printWriter.write("&lt;");
                    continue block7;
                }
                case '>': {
                    printWriter.write("&gt;");
                    continue block7;
                }
                case '&': {
                    printWriter.write("&amp;");
                    continue block7;
                }
                default: {
                    printWriter.write(c);
                }
            }
        }
    }

    public static String getBaseName(String string) {
        return "scilab_" + string + "_help";
    }

    public static String getTemporaryNameFo(String string) {
        return string + "/__doc.fo";
    }

    public static String getFileExtension(File file) {
        return Helpers.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String string) {
        int n = Helpers.indexOfDot(string);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    private static int indexOfDot(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        n = n < 0 ? 0 : ++n;
        int n2 = -1;
        int n3 = string.length();
        while ((n3 = string.lastIndexOf(46, n3 - 1)) > n) {
            n2 = n3;
        }
        return n2;
    }

    public static File setFileExtension(File file, String string) {
        String string2 = Helpers.setFileExtension(file.getPath(), string);
        return new File(string2);
    }

    public static String setFileExtension(String string, String string2) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        int n = Helpers.indexOfDot(string);
        if (n < 0) {
            if (string2 == null) {
                return string;
            }
            return string + "." + string2;
        }
        if (string2 == null) {
            return string.substring(0, n);
        }
        return string.substring(0, n + 1) + string2;
    }

    public static void copyFile(File file, File file2) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Helpers.copyFile(fileInputStream, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[65536];
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
    }

    public static void deleteDirectory(String string) {
        Helpers.deleteDirectory(new File(string));
    }

    public static void deleteDirectory(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                Helpers.deleteDirectory(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static String[] split(String string, char c) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(c, n3)) >= 0) {
            ++n2;
            ++n3;
        }
        String[] stringArray = new String[++n2];
        n2 = 0;
        n3 = 0;
        while ((n = string.indexOf(c, n3)) >= 0) {
            stringArray[n2++] = n3 == n ? "" : string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2++] = string.substring(n3);
        return stringArray;
    }

    public static File findInPath(String string) {
        String string2 = System.getenv("PATH");
        if (string2 == null) {
            return null;
        }
        String[] stringArray = Helpers.split(string2, File.pathSeparatorChar);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            Object object = stringArray[i].trim();
            if (((String)object).length() == 0) continue;
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            if ((file = new File((String)object + string)).isFile()) {
                return file;
            }
            if (!IS_WINDOWS || string.lastIndexOf(46) >= 0) continue;
            String[] stringArray2 = new String[]{".COM", ".EXE", ".BAT", ".CMD"};
            String string3 = System.getenv("PATHEXT");
            if (string3 != null) {
                stringArray2 = Helpers.split(string3, File.pathSeparatorChar);
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                String string4 = stringArray2[j].trim();
                if (!string4.startsWith(".") || !(file = new File((String)object + string + string4)).isFile()) continue;
                return file;
            }
        }
        return null;
    }

    public static Process shellStart(String string, String[] stringArray, File file) throws IOException {
        Process process = IS_WINDOWS ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/s", "/c", "\"" + string + "\""}, stringArray, file) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string}, stringArray, file);
        return process;
    }

    public static int shellExec(String string, String[] stringArray, File file, boolean bl) throws IOException, InterruptedException {
        InputConsumer inputConsumer;
        InputConsumer inputConsumer2;
        if (bl) {
            System.out.println(string);
        }
        Process process = Helpers.shellStart(string, stringArray, file);
        if (bl) {
            inputConsumer2 = new InputConsumer(process.getInputStream(), System.out);
            inputConsumer = new InputConsumer(process.getErrorStream(), System.err);
        } else {
            inputConsumer2 = new InputConsumer(process.getInputStream());
            inputConsumer = new InputConsumer(process.getErrorStream());
        }
        inputConsumer2.start();
        inputConsumer.start();
        int n = process.waitFor();
        inputConsumer2.join();
        inputConsumer.join();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file, String string) throws IOException {
        String string2 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            string2 = Helpers.loadString(fileInputStream, string);
        }
        return string2;
    }

    public static String loadString(InputStream inputStream, String string) throws IOException {
        int n;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream, "UTF-8") : new InputStreamReader(inputStream, string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String string, File file, String string2) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            Helpers.saveString(string, fileOutputStream, string2);
        }
    }

    private static void saveString(String string, OutputStream outputStream, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream, "UTF-8") : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
    }

    private static class InputConsumer
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private byte[] bytes = new byte[4096];

        public InputConsumer(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputConsumer(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            while (true) {
                int n;
                try {
                    n = this.in.read(this.bytes);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n < 0) break;
                if (n <= 0 || this.out == null) continue;
                try {
                    this.out.write(this.bytes, 0, n);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
        }
    }
}

