/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.console;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.io.PrintStream;
import org.scilab.modules.gui.bridge.ScilabBridge;
import org.scilab.modules.gui.console.Console;
import org.scilab.modules.gui.console.SimpleConsole;
import org.scilab.modules.gui.dockable.ScilabDockable;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.ScilabPrintStream;
import org.scilab.modules.gui.utils.Size;

public class ScilabConsole
extends ScilabDockable
implements Console {
    private static Console instance;
    private SimpleConsole component = ScilabBridge.createConsole();

    protected ScilabConsole() {
    }

    public static Console createConsole() {
        if (instance == null) {
            instance = new ScilabConsole();
            if (ScilabPrintStream.isAvailable()) {
                PrintStream printStream = System.err;
                System.setErr(ScilabPrintStream.getInstance());
                ScilabPrintStream.setRedirect(printStream);
            }
        }
        return instance;
    }

    public static Console getConsole() {
        if (instance == null) {
            return new ScilabConsole();
        }
        return instance;
    }

    public static boolean isExistingConsole() {
        return instance != null;
    }

    @Override
    public SimpleConsole getAsSimpleConsole() {
        return this.component;
    }

    @Override
    public void display(String string) {
        ScilabBridge.display(this, string);
    }

    @Override
    public String readLine() {
        return ScilabBridge.readLine(this);
    }

    @Override
    public void draw() {
        ScilabBridge.draw(this);
    }

    @Override
    public Size getDims() {
        return ScilabBridge.getDims(this);
    }

    @Override
    public Position getPosition() {
        return ScilabBridge.getPosition(this);
    }

    @Override
    public boolean isVisible() {
        return ScilabBridge.isVisible(this);
    }

    @Override
    public void setDims(Size size) {
        ScilabBridge.setDims(this, size);
    }

    @Override
    public void setPosition(Position position) {
        ScilabBridge.setPosition((Console)this, position);
    }

    @Override
    public void setVisible(boolean bl) {
        ScilabBridge.setVisible(this, bl);
    }

    @Override
    public void clear() {
        ScilabBridge.clear(this);
    }

    @Override
    public void clear(int n) {
        ScilabBridge.clear(this, n);
    }

    @Override
    public void toHome() {
        ScilabBridge.toHome(this);
    }

    public int getCharWithoutOutput() {
        return ScilabBridge.getCharWithoutOutput(this);
    }

    @Override
    public void setPrompt(String string) {
        ScilabBridge.setPrompt(this, string);
    }

    @Override
    public void scilabLinesUpdate() {
        ScilabBridge.scilabLinesUpdate(this);
    }

    @Override
    public boolean isWaitingForInput() {
        return ScilabBridge.isWaitingForInput(this);
    }

    @Override
    public void clearHistory() {
        ScilabBridge.clearHistory(this);
    }

    @Override
    public void selectAll() {
        ScilabBridge.selectAll(this);
    }

    @Override
    public void copyToClipboard() {
        ScilabBridge.copyToClipboard(this);
    }

    @Override
    public void pasteClipboard() {
        ScilabBridge.pasteClipboard(this);
    }

    @Override
    public void cutSelection() {
        ScilabBridge.cutSelection(this);
    }

    @Override
    public void setFont(Font font) {
        ScilabBridge.setFont(this, font);
    }

    @Override
    public Font getFont() {
        return ScilabBridge.getFont(this);
    }

    @Override
    public Color getForeground() {
        return ScilabBridge.getForeground(this);
    }

    @Override
    public Color getBackground() {
        return ScilabBridge.getBackground(this);
    }

    @Override
    public void setForeground(Color color) {
        ScilabBridge.setForeground(this, color);
    }

    @Override
    public void setBackground(Color color) {
        ScilabBridge.setBackground(this, color);
    }

    @Override
    public void setMaxOutputSize(int n) {
        ScilabBridge.setMaxOutputSize(this, n);
    }

    @Override
    public void setCursor(Cursor cursor) {
        ScilabBridge.setCursor(this, cursor);
    }

    @Override
    public void helpOnTheKeyword() {
        ScilabBridge.helpOnTheKeyword(this);
    }

    @Override
    public void evaluateSelectionWithEcho() {
        ScilabBridge.evaluateSelectionWithEcho(this);
    }

    @Override
    public void evaluateSelectionWithNoEcho() {
        ScilabBridge.evaluateSelectionWithNoEcho(this);
    }
}

