/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.tree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tree.ScilabTreeCellRenderer;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.tree.SimpleTree;
import org.scilab.modules.gui.tree.Tree;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.localization.Messages;

public class SwingScilabTree
extends DefaultMutableTreeNode
implements SimpleTree {
    private static final long serialVersionUID = 1L;
    private Icon icon;
    private CommonCallBack callback;
    private JScrollPane scrollPane = new JScrollPane();

    public SwingScilabTree(Tree tree) {
        super(tree.getLabel());
        this.setIcon(tree.getIcon());
        this.setCallback(tree.getCallback());
        Vector<Tree> vector = tree.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            SwingScilabTree swingScilabTree = new SwingScilabTree(vector.get(i));
            this.add(swingScilabTree);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public CommonCallBack getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    public JComponent getAsComponent() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this);
        ScilabTreeCellRenderer scilabTreeCellRenderer = new ScilabTreeCellRenderer();
        JTree jTree = new JTree();
        jTree.setShowsRootHandles(true);
        jTree.setModel(defaultTreeModel);
        jTree.setCellRenderer(scilabTreeCellRenderer);
        jTree.addMouseListener(new ClickListener(jTree));
        jTree.setVisible(true);
        this.scrollPane.getViewport().add(jTree);
        return this.scrollPane;
    }

    public JTree getJTree() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this);
        ScilabTreeCellRenderer scilabTreeCellRenderer = new ScilabTreeCellRenderer();
        JTree jTree = new JTree();
        jTree.setShowsRootHandles(true);
        jTree.setModel(defaultTreeModel);
        jTree.setCellRenderer(scilabTreeCellRenderer);
        jTree.addMouseListener(new ClickListener(jTree));
        jTree.setVisible(true);
        return jTree;
    }

    public static void showTree(Tree tree) {
        Runnable runnable = () -> {
            SwingScilabTree swingScilabTree = new SwingScilabTree(tree);
            SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow(true);
            final SwingScilabDockablePanel swingScilabDockablePanel = new SwingScilabDockablePanel(Messages.gettext((String)"Tree Overview"));
            ClosingOperationsManager.addDependencyWithRoot(swingScilabDockablePanel);
            swingScilabDockablePanel.setCallback(new CommonCallBack("", -1){
                private static final long serialVersionUID = 8418506008885202932L;

                @Override
                public void callBack() {
                    swingScilabDockablePanel.close();
                }
            });
            swingScilabDockablePanel.addTree(swingScilabTree);
            swingScilabWindow.addTab(swingScilabDockablePanel);
            swingScilabDockablePanel.setVisible(true);
            swingScilabWindow.setVisible(true);
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void setForeground(Color color) {
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setRelief(String string) {
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void addInfoBar(TextBox textBox) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
    }

    @Override
    public void draw() {
    }

    @Override
    public Size getDims() {
        return new Size(this.scrollPane.getSize().width, this.scrollPane.getSize().height);
    }

    @Override
    public TextBox getInfoBar() {
        return null;
    }

    @Override
    public MenuBar getMenuBar() {
        return null;
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.scrollPane.getLocation(), this.scrollPane.getSize(), this.scrollPane.getParent());
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setDims(Size size) {
        this.scrollPane.setSize(new Dimension(size.getWidth(), size.getHeight()));
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.scrollPane.getParent());
        this.scrollPane.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public void setToolTipText(String string) {
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Tree.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Tree.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    private static class ClickListener
    extends MouseAdapter {
        private JTree myJtree;

        public ClickListener(JTree jTree) {
            this.myJtree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = this.myJtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && mouseEvent.getClickCount() >= 2) {
                ((SwingScilabTree)treePath.getLastPathComponent()).getCallback().actionPerformed(null);
            }
        }
    }
}

