/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.label;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabLabel
extends JScrollPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 7177323379068859441L;
    private Integer uid;
    private JComponent label = new JLabel(" ");
    private Border defaultBorder = null;
    private LabelStyle labelStyle = null;
    private String horizontalAlignment = "left";
    private String verticalAlignment = "middle";
    private final JPanel alignmentPanel = new JPanel();
    private final GridBagLayout alignmentLayout = new GridBagLayout();
    private String labelText = "";
    private static HyperlinkListener urlOpener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                WebBrowser.openUrl(hyperlinkEvent.getURL(), hyperlinkEvent.getDescription());
            }
        }
    };

    public SwingScilabLabel() {
        this.alignmentPanel.setLayout(this.alignmentLayout);
        this.setViewportView(this.label);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.setAlignment();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = SwingScilabLabel.this.getVerticalScrollBar().getValue();
                if (n == SwingScilabLabel.this.getVerticalScrollBar().getMinimum() || n == SwingScilabLabel.this.getVerticalScrollBar().getMaximum() - SwingScilabLabel.this.getVerticalScrollBar().getVisibleAmount()) {
                    SwingScilabLabel.this.getParent().dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
            this.setMinimumSize(this.label.getMinimumSize());
            if (this.labelStyle == LabelStyle.HTML) {
                StyleSheet styleSheet = ((HTMLDocument)((JTextPane)this.label).getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family:" + font.getName() + ";}");
                styleSheet.addRule("body {font-size:" + font.getSize() + "pt;}");
                if (font.isBold()) {
                    styleSheet.addRule("body {font-weight:bold;}");
                } else {
                    styleSheet.addRule("body {font-weight:normal;}");
                }
                if (font.isItalic()) {
                    styleSheet.addRule("body {font-style:italic;}");
                } else {
                    styleSheet.addRule("body {font-style:normal;}");
                }
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.alignmentPanel != null) {
            this.alignmentPanel.setBackground(color);
        }
        if (this.label != null) {
            if (this.label instanceof JLabel) {
                ((JLabel)this.label).setOpaque(true);
            }
            this.label.setBackground(color);
        }
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.horizontalAlignment = string;
        this.setAlignment();
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.verticalAlignment = string;
        this.setAlignment();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.labelText;
    }

    @Override
    public void setText(String string) {
        JFrame jFrame;
        this.labelText = string;
        if (this.labelText != null) {
            if (this.labelText.startsWith("<math>") && this.labelText.endsWith("</math>")) {
                boolean bl = ScilabSpecialTextUtilities.setText((JComponent)new JLabel(), (String)this.labelText);
                if (bl) {
                    this.changeLabelType(LabelStyle.MATHML);
                    ((IconLabel)this.label).setText(this.labelText);
                } else {
                    this.changeLabelType(LabelStyle.TEXT);
                    ((JLabel)this.label).setText(this.labelText);
                }
                return;
            }
            if (this.labelText.startsWith("<html>") && this.labelText.endsWith("</html>")) {
                this.changeLabelType(LabelStyle.HTML);
                ((JEditorPane)this.label).setText(this.labelText);
                return;
            }
            if (this.labelText.startsWith("<a href") && this.labelText.endsWith("</a>")) {
                this.changeLabelType(LabelStyle.HTML);
                ((JEditorPane)this.label).setText(this.labelText);
                return;
            }
            if (this.labelText.startsWith("$") && this.labelText.endsWith("$")) {
                boolean bl = ScilabSpecialTextUtilities.setText((JComponent)new JLabel(), (String)this.labelText);
                if (bl) {
                    this.changeLabelType(LabelStyle.LATEX);
                    ((IconLabel)this.label).setText(this.labelText);
                } else {
                    this.changeLabelType(LabelStyle.TEXT);
                    ((JLabel)this.label).setText(this.labelText);
                }
                return;
            }
        }
        if ((jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)) != null) {
            jFrame.invalidate();
        }
        this.changeLabelType(LabelStyle.TEXT);
        ((JLabel)this.label).setText(this.labelText);
        this.setMinimumSize(this.label.getMinimumSize());
        if (jFrame != null) {
            jFrame.validate();
        }
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    private void changeLabelType(LabelStyle labelStyle) {
        if (this.labelStyle == labelStyle) {
            return;
        }
        this.labelStyle = labelStyle;
        Color color = this.label.getBackground();
        Color color2 = this.label.getForeground();
        Font font = this.label.getFont();
        Dimension dimension = this.label.getSize();
        this.label.setVisible(false);
        switch (this.labelStyle) {
            case LATEX: {
                this.alignmentPanel.remove(this.label);
                this.label = new IconLabel(IconLabel.IconType.LATEX);
                this.setViewportView(this.label);
                this.setVerticalScrollBarPolicy(21);
                break;
            }
            case MATHML: {
                this.alignmentPanel.remove(this.label);
                this.label = new IconLabel(IconLabel.IconType.MATHML);
                this.setViewportView(this.label);
                this.setVerticalScrollBarPolicy(21);
                break;
            }
            case HTML: {
                JTextPane jTextPane = new JTextPane();
                jTextPane.addHyperlinkListener(urlOpener);
                jTextPane.setContentType("text/html");
                jTextPane.setEditable(false);
                StyleSheet styleSheet = ((HTMLDocument)jTextPane.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family:" + font.getName() + ";}");
                styleSheet.addRule("body {font-size:" + font.getSize() + "pt;}");
                if (font.isBold()) {
                    styleSheet.addRule("body {font-weight:bold;}");
                } else {
                    styleSheet.addRule("body {font-weight:normal;}");
                }
                if (font.isItalic()) {
                    styleSheet.addRule("body {font-style:italic;}");
                } else {
                    styleSheet.addRule("body {font-style:normal;}");
                }
                this.label = jTextPane;
                this.alignmentPanel.add(this.label);
                this.setViewportView(this.alignmentPanel);
                this.setVerticalScrollBarPolicy(20);
                break;
            }
            case TEXT: {
                this.alignmentPanel.remove(this.label);
                this.label = new JLabel();
                this.setViewportView(this.label);
                this.update(329, GraphicController.getController().getProperty(this.getId(), 329));
                ((JLabel)this.label).setOpaque(false);
                this.setVerticalScrollBarPolicy(21);
            }
        }
        this.setBackground(color);
        this.label.setForeground(color2);
        this.label.setFont(font);
        this.label.setSize(dimension);
        this.label.setVisible(true);
        this.setAlignment();
    }

    private void setAlignment() {
        if (this.labelStyle != LabelStyle.HTML) {
            ((JLabel)this.label).setVerticalAlignment(ScilabAlignment.toSwingAlignment(this.verticalAlignment));
            ((JLabel)this.label).setHorizontalAlignment(ScilabAlignment.toSwingAlignment(this.horizontalAlignment));
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        block0 : switch (ScilabAlignment.toSwingAlignment(this.horizontalAlignment)) {
            case 2: {
                switch (ScilabAlignment.toSwingAlignment(this.verticalAlignment)) {
                    case 1: {
                        gridBagConstraints.anchor = 18;
                        break block0;
                    }
                    case 0: {
                        gridBagConstraints.anchor = 17;
                        break block0;
                    }
                }
                gridBagConstraints.anchor = 16;
                break;
            }
            case 0: {
                switch (ScilabAlignment.toSwingAlignment(this.verticalAlignment)) {
                    case 1: {
                        gridBagConstraints.anchor = 11;
                        break block0;
                    }
                    case 0: {
                        gridBagConstraints.anchor = 10;
                        break block0;
                    }
                }
                gridBagConstraints.anchor = 15;
                break;
            }
            default: {
                switch (ScilabAlignment.toSwingAlignment(this.verticalAlignment)) {
                    case 1: {
                        gridBagConstraints.anchor = 12;
                        break block0;
                    }
                    case 0: {
                        gridBagConstraints.anchor = 13;
                        break block0;
                    }
                }
                gridBagConstraints.anchor = 14;
            }
        }
        this.alignmentLayout.setConstraints(this.label, gridBagConstraints);
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        switch (n) {
            case 329: {
                if (this.labelStyle != LabelStyle.TEXT) break;
                String string = (String)object;
                if (string != null && !string.equals("")) {
                    File file = new File((String)object);
                    if (!file.exists()) {
                        String string2 = FindIconHelper.findImage((String)((String)object));
                        file = new File(string2);
                    }
                    try {
                        ((JLabel)this.label).setIcon(new ImageIcon(ImageIO.read(file)));
                    }
                    catch (IOException iOException) {}
                    break;
                }
                ((JLabel)this.label).setIcon(null);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Label.background");
        if (color != null) {
            if (this.label instanceof JLabel) {
                ((JLabel)this.label).setOpaque(true);
            }
            this.label.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Label.foreground");
        if (color != null) {
            this.label.setForeground(color);
        }
    }

    private static enum LabelStyle {
        TEXT,
        LATEX,
        MATHML,
        HTML;

    }

    public static class IconLabel
    extends JLabel {
        private static final long serialVersionUID = 3885565301114930030L;
        private static final Font DEFAULTFONT = new Font("serif", 0, 12);
        private static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") != -1;
        private Icon icon = null;
        private Icon iconDisable = null;
        private float fontSize = 12.0f;
        private String text;
        private Dimension preferred;
        IconType type = IconType.MATHML;

        public IconLabel(IconType iconType) {
            this.preferred = new Dimension(0, 0);
            this.type = iconType;
        }

        @Override
        public void setText(String string) {
            this.text = string;
            this.update();
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferred;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isOpaque() && this.getBackground() != null) {
                Color color = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(color);
            }
            int n = this.getHorizontalAlignment();
            int n2 = this.getVerticalAlignment();
            int n3 = 0;
            int n4 = 0;
            if (n == 0) {
                n3 = (this.getSize().width - this.icon.getIconWidth()) / 2;
            } else if (n == 4) {
                n3 = this.getSize().width - this.icon.getIconWidth();
            }
            if (n2 == 0) {
                n4 = (this.getSize().height - this.icon.getIconHeight()) / 2;
            } else if (n2 == 3) {
                n4 = this.getSize().height - this.icon.getIconHeight();
            }
            if (this.type == IconType.LATEX) {
                TeXIcon teXIcon = (TeXIcon)this.icon;
                if (this.isEnabled()) {
                    teXIcon.setForeground(this.getForeground());
                    teXIcon.paintIcon((Component)this, graphics, n3, n4);
                } else if (isWindows && UIManager.getColor("Label.disabledForeground") instanceof Color && UIManager.getColor("Label.disabledShadow") instanceof Color) {
                    teXIcon.setForeground(UIManager.getColor("Label.disabledShadow"));
                    teXIcon.paintIcon((Component)this, graphics, n3 + 1, n4 + 1);
                    teXIcon.setForeground(UIManager.getColor("Label.disabledForeground"));
                    teXIcon.paintIcon((Component)this, graphics, n3, n4);
                } else {
                    teXIcon.setForeground(this.getBackground().brighter());
                    teXIcon.paintIcon((Component)this, graphics, n3 + 1, n4 + 1);
                    teXIcon.setForeground(this.getBackground().darker());
                    teXIcon.paintIcon((Component)this, graphics, n3, n4);
                }
            } else if (this.isEnabled()) {
                this.icon.paintIcon(this, graphics, n3, n4);
            } else {
                this.icon.paintIcon(this, graphics, n3 + 1, n4 + 1);
                this.iconDisable.paintIcon(this, graphics, n3, n4);
            }
        }

        @Override
        public void setFont(Font font) {
            this.fontSize = font.getSize2D();
            this.update();
        }

        @Override
        public Font getFont() {
            return DEFAULTFONT;
        }

        private void update() {
            if (!this.text.equals("")) {
                if (this.type == IconType.LATEX) {
                    this.icon = new TeXFormula.TeXIconBuilder(new TeXFormula(this.text)).setStyle(0).setSize(this.fontSize).build();
                } else if (this.isEnabled()) {
                    this.icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)this.text, (int)((int)this.fontSize));
                } else if (isWindows && UIManager.getColor("Label.disabledForeground") instanceof Color && UIManager.getColor("Label.disabledShadow") instanceof Color) {
                    this.icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)this.text, (int)((int)this.fontSize), (Color)UIManager.getColor("Label.disabledShadow"));
                    this.iconDisable = ScilabSpecialTextUtilities.compileMathMLExpression((String)this.text, (int)((int)this.fontSize), (Color)UIManager.getColor("Label.disabledForeground"));
                } else {
                    this.icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)this.text, (int)((int)this.fontSize), (Color)this.getBackground().brighter());
                    this.iconDisable = ScilabSpecialTextUtilities.compileMathMLExpression((String)this.text, (int)((int)this.fontSize), (Color)this.getBackground().darker());
                }
                this.preferred = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.update();
        }

        public static enum IconType {
            LATEX,
            MATHML;

        }
    }
}

