/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.graphic_export.FileExporter;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.filechooser.ExportData;
import org.scilab.modules.gui.bridge.filechooser.ExportOptionWindow;
import org.scilab.modules.gui.bridge.filechooser.FileMask;
import org.scilab.modules.gui.bridge.filechooser.ImagePreview;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;

public class SwingScilabExportFileChooser
extends SwingScilabFileChooser {
    private static final int NB_FILE_MASKS = 12;
    private final String bmpDesc = Messages.gettext((String)"Windows BMP image");
    private final String gifDesc = Messages.gettext((String)"GIF image");
    private final String jpgDesc = Messages.gettext((String)"JPEG image");
    private final String pngDesc = Messages.gettext((String)"PNG image");
    private final String ppmDesc = Messages.gettext((String)"PPM image");
    private final String emfDesc = Messages.gettext((String)"Enhanced Metafile image (EMF)");
    private final String epsDesc = Messages.gettext((String)"Encapsulated PostScript image (EPS)");
    private final String psDesc = Messages.gettext((String)"PostScript image (PS)");
    private final String pdfDesc = Messages.gettext((String)"PDF image");
    private final String svgDesc = Messages.gettext((String)"SVG image");
    private final String allFilesDesc = Messages.gettext((String)"All files");
    private final String bmp = "bmp";
    private final String gif = "gif";
    private final String[] jpg = new String[]{"jpg", "jpeg"};
    private final String png = "png";
    private final String ppm = "ppm";
    private final String emf = "emf";
    private final String eps = "eps";
    private final String ps = "ps";
    private final String pdf = "pdf";
    private final String svg = "svg";
    private final String allFiles = "*";
    private String exportName;
    private String extensionSelected;
    private Integer figureUID;

    public SwingScilabExportFileChooser(Integer n) {
        this.figureUID = n;
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (JComponent)((Object)SwingView.getFromId(n)));
        this.setParentFrame(jFrame);
        this.exportCustomFileChooser(n);
    }

    public void exportCustomFileChooser(Integer n) {
        int n2;
        Object object;
        Figure figure = (Figure)GraphicController.getController().getObjectFromId(n);
        String string = figure.getName();
        int n3 = figure.getId();
        string = string != null && !string.isEmpty() ? string.replaceFirst("%d", Integer.toString(n3)) : Messages.gettext((String)"Untitled-export");
        ArrayList<FileMask> arrayList = new ArrayList<FileMask>(12);
        arrayList.add(new FileMask("png", this.pngDesc));
        arrayList.add(new FileMask(this.jpg, this.jpgDesc));
        arrayList.add(new FileMask("eps", this.epsDesc));
        arrayList.add(new FileMask("ps", this.psDesc));
        arrayList.add(new FileMask("pdf", this.pdfDesc));
        arrayList.add(new FileMask("svg", this.svgDesc));
        arrayList.add(new FileMask("emf", this.emfDesc));
        arrayList.add(new FileMask("gif", this.gifDesc));
        arrayList.add(new FileMask("bmp", this.bmpDesc));
        arrayList.add(new FileMask("ppm", this.ppmDesc));
        arrayList.add(new FileMask("*", this.allFilesDesc));
        super.setDialogTitle(Messages.gettext((String)"Export"));
        super.setApproveButtonText(Messages.gettext((String)"Export"));
        File file = new File(string);
        super.setSelectedFile(file);
        super.setAcceptAllFileFilterUsed(false);
        this.figureUID = n;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (FileMask)arrayList.get(i);
            if (i == arrayList.size() - 1) {
                ((FileMask)object).clearExtensions();
            }
            super.addChoosableFileFilter((FileFilter)object);
        }
        JPanel jPanel = new JPanel();
        object = BorderFactory.createTitledBorder(Messages.gettext((String)"Preview selected image file"));
        jPanel.setBorder((Border)object);
        jPanel.add(new ImagePreview(this));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.setVisible(true);
        super.setAccessory(jPanel2);
        Window window = null;
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor((Integer)n);
        if (drawerVisitor != null) {
            Component component = drawerVisitor.getComponent();
            window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        }
        if ((n2 = super.showSaveDialog(window)) == 0 && super.getSelectedFile() != null) {
            this.exportName = super.getSelectedFile().getAbsolutePath();
            ConfigManager.saveLastOpenedDirectory(new File(this.exportName).getParentFile().getPath());
            String string2 = "";
            try {
                FileMask fileMask = (FileMask)super.getFileFilter();
                string2 = fileMask.getExtensionFromFilter();
                if (string2 == null) {
                    string2 = "*";
                }
            }
            catch (ClassCastException classCastException) {
                string2 = "*";
            }
            if (string2.equals("*")) {
                this.exportManager();
            } else if (string2.equals("emf") || string2.equals("eps") || string2.equals("ps") || string2.equals("pdf") || string2.equals("svg")) {
                this.vectorialExport(string2);
            } else {
                this.bitmapExport(string2);
            }
        }
    }

    private boolean canWriteFile(String string) {
        Component component;
        Window window;
        int n;
        return !new File(string).exists() || (n = JOptionPane.showConfirmDialog(window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component = DrawerVisitor.getVisitor((Integer)this.figureUID).getComponent()), Messages.gettext((String)"Replace existing file?"), Messages.gettext((String)"File already exists"), 0)) == 0;
    }

    public String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void exportManager() {
        String string = this.getExtension(this.exportName);
        if (string == null) {
            JOptionPane.showMessageDialog(this, Messages.gettext((String)"Please specify a file format"), Messages.gettext((String)"Error on export"), 0);
            return;
        }
        if (string.equals("bmp")) {
            this.bitmapExport(string);
        } else if (string.equals("gif")) {
            this.bitmapExport(string);
        } else if (string.equals(this.jpg[0]) || string.equals(this.jpg[1])) {
            this.bitmapExport(string);
        } else if (string.equals("png")) {
            this.bitmapExport(string);
        } else if (string.equals("ppm")) {
            this.bitmapExport(string);
        } else if (string.equals("emf")) {
            this.vectorialExport(string);
        } else if (string.equals("eps")) {
            this.vectorialExport(string);
        } else if (string.equals("pdf")) {
            this.vectorialExport(string);
        } else if (string.equals("svg")) {
            this.vectorialExport(string);
        } else {
            JOptionPane.showMessageDialog(this, String.format(Messages.gettext((String)"Unrecognized extension '%s'.\n Please specify a valid file format."), string), Messages.gettext((String)"Error on export"), 0);
            return;
        }
    }

    public void bitmapExport(String string) {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        ExportData exportData = new ExportData(this.figureUID, this.exportName, string, null);
        Object object = exportData.getExportName();
        if (this.getExtension((String)object) == null) {
            object = (String)object + "." + string;
        }
        if (!this.canWriteFile((String)object)) {
            return;
        }
        FileExporter.fileExport((int)this.figureUID, (String)object, (String)exportData.getExportExtension(), (float)-1.0f, (int)0);
        this.setCursor(cursor);
    }

    public void vectorialExport(String string) {
        SwingViewObject swingViewObject = SwingView.getFromId(this.figureUID);
        SimpleTab simpleTab = swingViewObject instanceof SimpleTab ? (SimpleTab)((Object)SwingView.getFromId(this.figureUID)) : null;
        ExportData exportData = new ExportData(this.figureUID, this.exportName, string, null);
        Object object = exportData.getExportName();
        if (this.getExtension((String)object) == null) {
            object = (String)object + "." + string;
        }
        if (!this.canWriteFile((String)object)) {
            return;
        }
        ExportOptionWindow exportOptionWindow = new ExportOptionWindow(exportData);
        exportOptionWindow.displayOptionWindow(simpleTab);
        exportOptionWindow.landscapePortraitOption();
    }
}

