/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.checkboxmenuitem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.commons.utils.StringBlockingResult;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.gui.SwingViewMenu;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.SimpleCheckBoxMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;

public class SwingScilabCheckBoxMenuItem
extends JCheckBoxMenuItem
implements SwingViewObject,
SimpleCheckBoxMenuItem {
    private static final long serialVersionUID = 1L;
    private CommonCallBack callback;
    private Menu meAsAMenu;
    private boolean autoCheckedMode = true;
    private String text = "";
    private Integer uid;
    private Border defaultBorder = null;

    public SwingScilabCheckBoxMenuItem() {
        this(true);
    }

    public SwingScilabCheckBoxMenuItem(boolean bl) {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBlockingResult.getInstance().setResult((Object)((SwingScilabCheckBoxMenuItem)actionEvent.getSource()).getText());
            }
        });
        this.autoCheckedMode = bl;
        if (!bl) {
            this.setModel(new ScilabCheckBoxMenuItemModel());
        }
    }

    @Override
    public String getBaseText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
        if (ScilabSpecialTextUtilities.setText((JComponent)this, (String)string)) {
            super.setText("");
        } else {
            super.setText(string);
        }
    }

    @Override
    public void setEmptyText() {
        this.text = null;
        this.setText(null);
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        if (this.callback != null) {
            this.removeActionListener(this.callback);
        }
        this.callback = commonCallBack;
        this.addActionListener(this.callback);
    }

    @Override
    public void setMnemonic(int n) {
        super.setMnemonic(n);
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Size getDims() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDims(Size size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void add(MenuItem menuItem) {
        if (this.meAsAMenu == null) {
            this.meAsAMenu = ScilabMenu.createMenu();
            this.meAsAMenu.setText(this.getText());
            this.meAsAMenu.add(menuItem);
            Container container = this.getParent();
            int n = container.getComponentZOrder(this);
            container.remove(this.getComponent());
            container.add((Component)((SwingScilabMenu)this.meAsAMenu.getAsSimpleMenu()), n);
        } else {
            this.meAsAMenu.add(menuItem);
        }
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.callback != null) {
            if (bl) {
                this.removeActionListener(this.callback);
                this.addActionListener(this.callback);
            } else {
                this.removeActionListener(this.callback);
            }
        }
    }

    @Override
    public void add(Menu menu) {
        if (this.meAsAMenu == null) {
            this.meAsAMenu = ScilabMenu.createMenu();
            this.meAsAMenu.setText(this.getText());
            this.meAsAMenu.add(menu);
            Container container = this.getParent();
            int n = container.getComponentZOrder(this);
            container.remove(this.getComponent());
            container.add((Component)((SwingScilabMenu)this.meAsAMenu.getAsSimpleMenu()), n);
        } else {
            this.meAsAMenu.add(menu);
        }
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommonCallBack getCallback() {
        return this.callback;
    }

    @Override
    public void setChecked(boolean bl) {
        if (this.autoCheckedMode) {
            this.setSelected(bl);
        } else {
            ((ScilabCheckBoxMenuItemModel)this.getModel()).forceSelected(bl);
        }
    }

    @Override
    public boolean isChecked() {
        return this.isSelected();
    }

    @Override
    public void add(CheckBoxMenuItem checkBoxMenuItem) {
        if (this.meAsAMenu == null) {
            this.meAsAMenu = ScilabMenu.createMenu();
            this.meAsAMenu.setText(this.getText());
            this.meAsAMenu.add(checkBoxMenuItem);
            Container container = this.getParent();
            int n = container.getComponentZOrder(this);
            container.remove(this.getComponent());
            container.add((Component)((SwingScilabMenu)this.meAsAMenu.getAsSimpleMenu()), n);
        } else {
            this.meAsAMenu.add(checkBoxMenuItem);
        }
    }

    @Override
    public void addSeparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        SwingViewMenu.update(this, n, object);
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("CheckBoxMenuItem.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("CheckBoxMenuItem.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    private class ScilabCheckBoxMenuItemModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 1L;

        @Override
        public void setSelected(boolean bl) {
        }

        public void forceSelected(boolean bl) {
            super.setSelected(bl);
        }
    }
}

