/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.browser;

import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefCookieVisitor;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabBrowser;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabBrowser
extends JPanel
implements SwingViewObject,
Widget {
    private String callback;
    private Integer callbackType;
    private Integer uid;
    private CefClient client_ = ScilabBrowser.get();
    private CefBrowser browser_ = this.client_.createBrowser(this.url, false, false);
    private boolean devToolsOpened = false;
    private Boolean debug = false;
    private String url = "";
    private String helpers;
    private String cookies = "";

    public SwingScilabBrowser() {
        this.client_.addMessageRouter(CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)new CefMessageRouter.CefMessageRouterConfig("Scilab", "ScilabAbort"), (CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser cefBrowser, CefFrame cefFrame, long l, String string, boolean bl, CefQueryCallback cefQueryCallback) {
                if (SwingScilabBrowser.this.browser_ == cefBrowser) {
                    cefQueryCallback.success(String.valueOf(l));
                    return SwingScilabBrowser.this.ExecuteCallBack(string, l) == 0;
                }
                return false;
            }
        }));
        this.client_.addKeyboardHandler((CefKeyboardHandler)new CefKeyboardHandlerAdapter(){

            public boolean onKeyEvent(CefBrowser cefBrowser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
                if (cefBrowser == SwingScilabBrowser.this.browser_) {
                    boolean bl;
                    boolean bl2 = OS.get() == OS.MAC;
                    boolean bl3 = !bl2 && (cefKeyEvent.modifiers & 4) == 4;
                    boolean bl4 = bl2 && (cefKeyEvent.modifiers & 0x80) == 128;
                    boolean bl5 = bl = (cefKeyEvent.modifiers & 2) == 2;
                    if (cefKeyEvent.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                        switch (cefKeyEvent.windows_key_code) {
                            case 73: {
                                if (!bl3 && !bl4 || !bl) break;
                                if (SwingScilabBrowser.this.debug.booleanValue()) {
                                    SwingScilabBrowser.this.openDebug(true);
                                }
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        });
        this.client_.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser cefBrowser) {
                if (cefBrowser == SwingScilabBrowser.this.browser_ && SwingScilabBrowser.this.url != "") {
                    cefBrowser.loadURL(SwingScilabBrowser.this.url);
                    SwingScilabBrowser.this.url = "";
                }
            }
        });
        this.client_.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest.TransitionType transitionType) {
                if (cefBrowser == SwingScilabBrowser.this.browser_) {
                    cefBrowser.executeJavaScript(SwingScilabBrowser.this.helpers, "localhost", 1);
                }
            }

            public void onLoadEnd(CefBrowser cefBrowser, CefFrame cefFrame, int n) {
                if (cefBrowser == SwingScilabBrowser.this.browser_) {
                    SwingScilabBrowser.this.updateCookies();
                    String[] stringArray = new String[]{cefBrowser.getURL()};
                    GraphicModel.getModel().setProperty(SwingScilabBrowser.this.uid, 308, (Object)stringArray);
                    SwingScilabBrowser.this.ExecuteCallBack("\"loaded\"", -1L);
                }
            }

            public void onLoadError(CefBrowser cefBrowser, CefFrame cefFrame, CefLoadHandler.ErrorCode errorCode, String string, String string2) {
                if (cefBrowser == SwingScilabBrowser.this.browser_) {
                    try {
                        Path path = Paths.get(ScilabConstants.SCI.getAbsolutePath() + "/modules/gui/etc/error.html", new String[0]);
                        Path path2 = Paths.get(ScilabConstants.TMPDIR.getAbsolutePath() + "/" + UUID.randomUUID().toString() + ".html", new String[0]);
                        String string3 = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                        string3 = string3.replace("<!--TAG ERROR-->", string);
                        Files.write(path2, string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        Path path3 = Paths.get(ScilabConstants.SCI.getAbsolutePath() + "/modules/gui/images/icons/256x256/apps/puffin.png", new String[0]);
                        Path path4 = Paths.get(ScilabConstants.TMPDIR.getAbsolutePath() + "/puffin.png", new String[0]);
                        Files.copy(path3, path4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        SwingScilabBrowser.this.browser_.loadURL("file:///" + String.valueOf(path2));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.client_.addContextMenuHandler((CefContextMenuHandler)new CefContextMenuHandlerAdapter(){

            public void onBeforeContextMenu(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, CefMenuModel cefMenuModel) {
                if (cefMenuModel.getCount() == 5 && cefMenuModel.getLabel(cefMenuModel.getCommandIdAt(0)).equals("&Back") && cefMenuModel.getLabel(cefMenuModel.getCommandIdAt(1)).equals("&Forward")) {
                    cefMenuModel.clear();
                }
            }
        });
        try {
            this.helpers = new String(Files.readAllBytes(Paths.get(ScilabConstants.SCI.getCanonicalPath(), "/modules/gui/etc/ScilabBrowser.js")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.invalidate();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.browser_.getUIComponent(), "Center");
        this.validate();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException("Unimplemented method 'addToolBar'");
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException("Unimplemented method 'addMenuBar'");
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException("Unimplemented method 'addInfoBar'");
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException("Unimplemented method 'draw'");
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException("Unimplemented method 'getMenuBar'");
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException("Unimplemented method 'getToolBar'");
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException("Unimplemented method 'getInfoBar'");
    }

    @Override
    public void resetBackground() {
        throw new UnsupportedOperationException("Unimplemented method 'resetBackground'");
    }

    @Override
    public void resetForeground() {
        throw new UnsupportedOperationException("Unimplemented method 'resetForeground'");
    }

    @Override
    public void setText(String string) {
        throw new UnsupportedOperationException("Unimplemented method 'setText'");
    }

    @Override
    public void setEmptyText() {
        throw new UnsupportedOperationException("Unimplemented method 'setEmptyText'");
    }

    @Override
    public String getText() {
        throw new UnsupportedOperationException("Unimplemented method 'getText'");
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void setHorizontalAlignment(String string) {
        throw new UnsupportedOperationException("Unimplemented method 'setHorizontalAlignment'");
    }

    @Override
    public void setVerticalAlignment(String string) {
        throw new UnsupportedOperationException("Unimplemented method 'setVerticalAlignment'");
    }

    @Override
    public void setRelief(String string) {
        throw new UnsupportedOperationException("Unimplemented method 'setRelief'");
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException("Unimplemented method 'destroy'");
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        switch (n) {
            case 308: {
                String[] stringArray = (String[])object;
                if (stringArray.length == 0 || stringArray[0].isEmpty()) {
                    this.url = "about:blank";
                } else {
                    Pattern pattern;
                    Matcher matcher;
                    this.url = stringArray[0];
                    if (!this.url.contains("://")) {
                        Path path = Paths.get(this.url, new String[0]);
                        if (!path.isAbsolute()) {
                            this.url = CommonFileUtils.getCWD() + "/" + this.url;
                        }
                        this.url = "file:///" + this.url;
                    } else if (this.url.startsWith("file://") && (matcher = (pattern = Pattern.compile("(file:/+)(.*)")).matcher(this.url)).find()) {
                        String string = matcher.group(1);
                        String string2 = matcher.group(2);
                        Path path = Paths.get(string2, new String[0]);
                        if (!path.isAbsolute()) {
                            this.url = string + CommonFileUtils.getCWD() + "/" + string2;
                        }
                    }
                }
                this.browser_.loadURL(this.url);
                break;
            }
            case 413: {
                String string = (String)object;
                if (string.equals("")) {
                    return;
                }
                string = string.replace("\"", "\\\"");
                String string3 = String.format("fromScilabInternal(\"%s\")", string);
                this.browser_.executeJavaScript(string3, "localhost", 1);
                break;
            }
            case 36: {
                this.callback = (String)object;
                break;
            }
            case 37: {
                this.callbackType = (Integer)object;
                break;
            }
            case 414: {
                this.debug = (Boolean)object;
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void removeNotify() {
        if (this.devToolsOpened) {
            this.browser_.closeDevTools();
            this.devToolsOpened = false;
        }
        if (this.browser_ != null) {
            this.browser_.close(false);
        }
        ScilabBrowser.release(this.client_);
        super.removeNotify();
    }

    public void openDebug(boolean bl) {
        if (bl) {
            if (this.devToolsOpened) {
                this.browser_.closeDevTools();
            } else {
                this.browser_.openDevTools();
            }
            this.devToolsOpened = !this.devToolsOpened;
        } else if (!this.devToolsOpened) {
            this.browser_.openDevTools();
            this.devToolsOpened = true;
        }
    }

    private int ExecuteCallBack(String string, long l) {
        if (this.callback != null && !this.callback.equals("")) {
            String string2 = string.replace("\"", "\"\"");
            String string3 = "if exists(\"gcbo\") then %oldgcbo = gcbo; end;gcbo = getcallbackobject(" + this.uid + ");%cb = #(data) -> (u = gcbo;u.data = struct(\"scilabcallbackID\", " + l + ", \"data\", data););" + this.callback + "(fromJSON(\"" + string2 + "\"), %cb);if exists(\"%oldgcbo\") then gcbo = %oldgcbo; else clear gcbo; end;clear %cb;";
            switch (this.callbackType) {
                case 0: 
                case 2: {
                    return InterpreterManagement.putCommandInScilabQueue((String)string3);
                }
                case 10: 
                case 12: {
                    return InterpreterManagement.requestScilabExec((String)string3);
                }
            }
        }
        return 0;
    }

    public String getCookies() {
        return this.cookies;
    }

    public void updateCookies() {
        CefCookieManager.getGlobalManager().visitAllCookies(new CefCookieVisitor(){
            List<CefCookie> l = new ArrayList<CefCookie>();

            public boolean visit(CefCookie cefCookie, int n, int n2, BoolRef boolRef) {
                if (!cefCookie.hasExpires) {
                    cefCookie = new CefCookie(cefCookie.name, cefCookie.value, cefCookie.domain, cefCookie.path, cefCookie.secure, cefCookie.httponly, cefCookie.creation, cefCookie.lastAccess, cefCookie.hasExpires, new Date(0L));
                }
                this.l.add(cefCookie);
                if (n == n2 - 1) {
                    Gson gson = new Gson();
                    SwingScilabBrowser.this.cookies = gson.toJson(this.l);
                }
                return true;
            }
        });
    }
}

