/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.concurrentrefhashmap;

import coursierapi.shaded.concurrentrefhashmap.IConcurrentMap;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements IConcurrentMap<K, V>,
Serializable {
    static final ReferenceType DEFAULT_KEY_TYPE = ReferenceType.WEAK;
    static final ReferenceType DEFAULT_VALUE_TYPE = ReferenceType.STRONG;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    boolean identityComparisons;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    private static int hash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    protected int hashOf(Object object) {
        return ConcurrentReferenceHashMap.hash(this.identityComparisons ? System.identityHashCode(object) : object.hashCode());
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2, ReferenceType referenceType, ReferenceType referenceType2, EnumSet<Option> enumSet) {
        int n3;
        int n4;
        int n5;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        this.segments = Segment.newArray(n5);
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 1; n3 < n4; n3 <<= 1) {
        }
        this.identityComparisons = enumSet != null && enumSet.contains((Object)Option.IDENTITY_COMPARISONS);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(n3, f, referenceType, referenceType2, this.identityComparisons);
        }
    }

    public ConcurrentReferenceHashMap(int n, float f, int n2) {
        this(n, f, n2, DEFAULT_KEY_TYPE, DEFAULT_VALUE_TYPE, null);
    }

    public ConcurrentReferenceHashMap(int n, ReferenceType referenceType, ReferenceType referenceType2) {
        this(n, 0.75f, 16, referenceType, referenceType2, null);
    }

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16);
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n;
        Segment<K, V>[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
            }
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    @Override
    public V get(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            int n3;
            n = 0;
            int n4 = 0;
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                n2 = segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n4 += nArray[n3];
                if (!segmentArray[n3].containsValue(object)) continue;
                return true;
            }
            n3 = 1;
            if (n4 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    int n5 = segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    n3 = 0;
                    break;
                }
            }
            if (n3 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, null, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).put(k, n, v, null, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hashOf(object);
        return this.segmentFor(n).remove(object, n, null, false);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n = this.hashOf(object);
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n).remove(object, n, object2, false) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = this.hashOf(k);
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(false));
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final boolean cached;

        public EntrySet(boolean bl) {
            this.cached = bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.cached ? new CachedEntryIterator() : new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = ConcurrentReferenceHashMap.this.get(entry.getKey());
            return v != null && v.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentReferenceHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentReferenceHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    protected static class InitializableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        protected InitializableEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public Map.Entry<K, V> init(K k, V v) {
            this.key = k;
            this.value = v;
            return this;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    final class CachedEntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private InitializableEntry entry;

        CachedEntryIterator() {
            this.entry = new InitializableEntry();
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return this.entry.init(hashEntry.key(), hashEntry.value());
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key(), hashEntry.value());
        }
    }

    protected class WriteThroughEntry
    extends SimpleEntry<K, V> {
        protected WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object v2 = super.setValue(v);
            ConcurrentReferenceHashMap.this.put(this.getKey(), v);
            return v2;
        }
    }

    protected static class SimpleEntry<K, V>
    implements Serializable,
    Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Enumeration<V>,
    Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value();
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Enumeration<K>,
    Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key();
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key();
        }
    }

    protected abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentReferenceHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentReferenceHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i = this.currentTable.length - 1; i >= 0; --i) {
                    this.nextEntry = this.currentTable[i];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<K, V>[] table;
        final float loadFactor;
        volatile transient ReferenceQueue<Object> refQueue;
        final ReferenceType keyType;
        final ReferenceType valueType;
        final boolean identityComparisons;

        Segment(int n, float f, ReferenceType referenceType, ReferenceType referenceType2, boolean bl) {
            this.loadFactor = f;
            this.keyType = referenceType;
            this.valueType = referenceType2;
            this.identityComparisons = bl;
            this.setTable(HashEntry.newArray(n));
        }

        static final <K, V> Segment<K, V>[] newArray(int n) {
            return new Segment[n];
        }

        private boolean keyEq(Object object, Object object2) {
            return this.identityComparisons ? object == object2 : object.equals(object2);
        }

        void setTable(HashEntry<K, V>[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
            this.refQueue = new ReferenceQueue();
        }

        HashEntry<K, V> getFirst(int n) {
            HashEntry<K, V>[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        HashEntry<K, V> newHashEntry(K k, int n, HashEntry<K, V> hashEntry, V v) {
            return new HashEntry<K, V>(k, n, hashEntry, v, this.keyType, this.valueType, this.refQueue);
        }

        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                this.removeStale();
                V v = hashEntry.value();
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        Object object2 = hashEntry.valueRef;
                        if (object2 != null) {
                            return hashEntry.dereferenceValue(object2);
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && this.keyEq(object, hashEntry.key())) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    while (hashEntry != null) {
                        Object object2 = hashEntry.valueRef;
                        V v = object2 == null ? this.readValueUnderLock(hashEntry) : hashEntry.dereferenceValue(object2);
                        if (object.equals(v)) {
                            return true;
                        }
                        hashEntry = hashEntry.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, int n, V v, V v2) {
            this.lock();
            try {
                boolean bl = this.replaceInternal2(k, n, v, v2);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        private boolean replaceInternal2(K k, int n, V v, V v2) {
            this.removeStale();
            HashEntry<K, V> hashEntry = this.getFirst(n);
            while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(k, hashEntry.key()))) {
                hashEntry = hashEntry.next;
            }
            boolean bl = false;
            if (hashEntry != null && v.equals(hashEntry.value())) {
                bl = true;
                hashEntry.setValue(v2, this.valueType, this.refQueue);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, int n, V v) {
            this.lock();
            try {
                V v2 = this.replaceInternal(k, n, v);
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        private V replaceInternal(K k, int n, V v) {
            this.removeStale();
            HashEntry<K, V> hashEntry = this.getFirst(n);
            while (!(hashEntry == null || hashEntry.hash == n && this.keyEq(k, hashEntry.key()))) {
                hashEntry = hashEntry.next;
            }
            V v2 = null;
            if (hashEntry != null) {
                v2 = hashEntry.value();
                hashEntry.setValue(v, this.valueType, this.refQueue);
            }
            return v2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, int n, V v, Function<? super K, ? extends V> function, boolean bl) {
            this.lock();
            try {
                V v2 = this.putInternal(k, n, v, function, bl);
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        private V putInternal(K k, int n, V v, Function<? super K, ? extends V> function, boolean bl) {
            V v2;
            HashEntry<K, V> hashEntry;
            int n2;
            this.removeStale();
            int n3 = this.count;
            if (n3++ > this.threshold && (n2 = this.rehash()) > 0) {
                this.count = (n3 -= n2) - 1;
            }
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n4 = n & hashEntryArray.length - 1;
            HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n4];
            while (!(hashEntry2 == null || hashEntry2.hash == n && this.keyEq(k, hashEntry2.key()))) {
                hashEntry2 = hashEntry2.next;
            }
            if (hashEntry2 != null) {
                v2 = hashEntry2.value();
                if (!bl) {
                    hashEntry2.setValue(this.getValue(k, v, function), this.valueType, this.refQueue);
                }
            } else {
                V v3 = this.getValue(k, v, function);
                Object object = v2 = function != null ? v3 : null;
                if (v3 != null) {
                    ++this.modCount;
                    hashEntryArray[n4] = this.newHashEntry(k, n, hashEntry, v3);
                    this.count = n3;
                }
            }
            return v2;
        }

        V getValue(K k, V v, Function<? super K, ? extends V> function) {
            return v != null ? v : function.apply(k);
        }

        int rehash() {
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] hashEntryArray2 = HashEntry.newArray(n << 1);
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                HashEntry<K, V> hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry<K, V> hashEntry3 = hashEntry;
                int n5 = n4;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    int n6 = hashEntry4.hash & n2;
                    if (n6 != n5) {
                        n5 = n6;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n5] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    Object k = hashEntry4.key();
                    if (k == null) {
                        ++n3;
                    } else {
                        int n7 = hashEntry4.hash & n2;
                        HashEntry hashEntry5 = hashEntryArray2[n7];
                        hashEntryArray2[n7] = this.newHashEntry(k, hashEntry4.hash, hashEntry5, hashEntry4.value());
                    }
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n, Object object2, boolean bl) {
            this.lock();
            try {
                V v = this.removeInternal(object, n, object2, bl);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private V removeInternal(Object object, int n, Object object2, boolean bl) {
            HashEntry<K, V> hashEntry;
            if (!bl) {
                this.removeStale();
            }
            int n2 = this.count - 1;
            HashEntry<K, V>[] hashEntryArray = this.table;
            int n3 = n & hashEntryArray.length - 1;
            HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n3];
            while (hashEntry2 != null && object != hashEntry2.keyRef && (bl || n != hashEntry2.hash || !this.keyEq(object, hashEntry2.key()))) {
                hashEntry2 = hashEntry2.next;
            }
            V v = null;
            if (hashEntry2 != null) {
                V v2 = hashEntry2.value();
                if (object2 == null || object2.equals(v2)) {
                    v = v2;
                    ++this.modCount;
                    HashEntry hashEntry3 = hashEntry2.next;
                    HashEntry<K, V> hashEntry4 = hashEntry;
                    while (hashEntry4 != hashEntry2) {
                        K k = hashEntry4.key();
                        if (k == null) {
                            --n2;
                        } else {
                            hashEntry3 = this.newHashEntry(k, hashEntry4.hash, hashEntry3, hashEntry4.value());
                        }
                        hashEntry4 = hashEntry4.next;
                    }
                    hashEntryArray[n3] = hashEntry3;
                    this.count = n2;
                }
            }
            return v;
        }

        final void removeStale() {
            KeyReference keyReference;
            while ((keyReference = (KeyReference)((Object)this.refQueue.poll())) != null) {
                this.remove(keyReference.keyRef(), keyReference.keyHash(), null, true);
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<K, V>[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.refQueue = new ReferenceQueue();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry<K, V> {
        final Object keyRef;
        final int hash;
        volatile Object valueRef;
        final HashEntry<K, V> next;

        HashEntry(K k, int n, HashEntry<K, V> hashEntry, V v, ReferenceType referenceType, ReferenceType referenceType2, ReferenceQueue<Object> referenceQueue) {
            this.hash = n;
            this.next = hashEntry;
            this.keyRef = this.newKeyReference(k, referenceType, referenceQueue);
            this.valueRef = this.newValueReference(v, referenceType2, referenceQueue);
        }

        final Object newKeyReference(K k, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new WeakKeyReference<K>(k, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new SoftKeyReference<K>(k, this.hash, referenceQueue);
            }
            return k;
        }

        final Object newValueReference(V v, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new WeakValueReference<V>(v, this.keyRef, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new SoftValueReference<V>(v, this.keyRef, this.hash, referenceQueue);
            }
            return v;
        }

        final K key() {
            if (this.keyRef instanceof KeyReference) {
                return (K)((Reference)this.keyRef).get();
            }
            return (K)this.keyRef;
        }

        final V value() {
            return this.dereferenceValue(this.valueRef);
        }

        final V dereferenceValue(Object object) {
            if (object instanceof KeyReference) {
                return (V)((Reference)object).get();
            }
            return (V)object;
        }

        final void setValue(V v, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            this.valueRef = this.newValueReference(v, referenceType, referenceQueue);
        }

        static final <K, V> HashEntry<K, V>[] newArray(int n) {
            return new HashEntry[n];
        }
    }

    static final class SoftValueReference<V>
    extends SoftReference<V>
    implements KeyReference {
        final Object keyRef;
        final int hash;

        SoftValueReference(V v, Object object, int n, ReferenceQueue<Object> referenceQueue) {
            super(v, referenceQueue);
            this.keyRef = object;
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this.keyRef;
        }
    }

    static final class WeakValueReference<V>
    extends WeakReference<V>
    implements KeyReference {
        final Object keyRef;
        final int hash;

        WeakValueReference(V v, Object object, int n, ReferenceQueue<Object> referenceQueue) {
            super(v, referenceQueue);
            this.keyRef = object;
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this.keyRef;
        }
    }

    static final class SoftKeyReference<K>
    extends SoftReference<K>
    implements KeyReference {
        final int hash;

        SoftKeyReference(K k, int n, ReferenceQueue<Object> referenceQueue) {
            super(k, referenceQueue);
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this;
        }
    }

    static final class WeakKeyReference<K>
    extends WeakReference<K>
    implements KeyReference {
        final int hash;

        WeakKeyReference(K k, int n, ReferenceQueue<Object> referenceQueue) {
            super(k, referenceQueue);
            this.hash = n;
        }

        @Override
        public final int keyHash() {
            return this.hash;
        }

        @Override
        public final Object keyRef() {
            return this;
        }
    }

    static interface KeyReference {
        public int keyHash();

        public Object keyRef();
    }

    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option IDENTITY_COMPARISONS = new Option();
        private static final /* synthetic */ Option[] $VALUES;

        static {
            $VALUES = new Option[]{IDENTITY_COMPARISONS};
        }
    }

    public static final class ReferenceType
    extends Enum<ReferenceType> {
        public static final /* enum */ ReferenceType STRONG = new ReferenceType();
        public static final /* enum */ ReferenceType WEAK = new ReferenceType();
        public static final /* enum */ ReferenceType SOFT = new ReferenceType();
        private static final /* synthetic */ ReferenceType[] $VALUES;

        static {
            $VALUES = new ReferenceType[]{STRONG, WEAK, SOFT};
        }
    }
}

