/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.debug;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;

public class ExpressionCompilerConfig {
    private final String packageName;
    private final String outputClassName;
    private final int breakpointLine;
    private final String expression;
    private final Set<String> localVariables;
    private final Consumer<String> errorReporter;
    private final boolean testMode;
    private final Names.TermName expressionTermName;
    private final Names.TypeName expressionClassName;

    public ExpressionCompilerConfig(String packageName, String outputClassName, int breakpointLine, String expression, Set<String> localVariables, Consumer<String> errorReporter, boolean testMode) {
        this.packageName = packageName;
        this.outputClassName = outputClassName;
        this.breakpointLine = breakpointLine;
        this.expression = expression;
        this.localVariables = localVariables;
        this.errorReporter = errorReporter;
        this.testMode = testMode;
        this.expressionTermName = Names$.MODULE$.termName(outputClassName.toLowerCase().toString());
        this.expressionClassName = Names$.MODULE$.typeName(outputClassName);
    }

    public int breakpointLine() {
        return this.breakpointLine;
    }

    public String expression() {
        return this.expression;
    }

    public Set<String> localVariables() {
        return this.localVariables;
    }

    public Consumer<String> errorReporter() {
        return this.errorReporter;
    }

    public boolean testMode() {
        return this.testMode;
    }

    public ExpressionCompilerConfig() {
        this("", "", -1, "", Collections.emptySet(), ExpressionCompilerConfig.ExpressionCompilerConfig$superArg$1(), false);
    }

    public ExpressionCompilerConfig withPackageName(String packageName) {
        return this.copy(packageName, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ExpressionCompilerConfig withOutputClassName(String outputClassName) {
        return this.copy(this.copy$default$1(), outputClassName, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ExpressionCompilerConfig withBreakpointLine(int breakpointLine) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), breakpointLine, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ExpressionCompilerConfig withExpression(String expression) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), expression, this.copy$default$5(), this.copy$default$6());
    }

    public ExpressionCompilerConfig withLocalVariables(Set<String> localVariables) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), localVariables, this.copy$default$6());
    }

    public ExpressionCompilerConfig withErrorReporter(Consumer<String> errorReporter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), errorReporter);
    }

    public Names.TermName expressionTermName() {
        return this.expressionTermName;
    }

    public Names.TypeName expressionClassName() {
        return this.expressionClassName;
    }

    public Symbols.ClassSymbol expressionClass(Contexts.Context x$1) {
        if (this.packageName.isEmpty()) {
            return Symbols$.MODULE$.requiredClass(this.outputClassName, x$1);
        }
        return Symbols$.MODULE$.requiredClass(this.packageName + "." + this.outputClassName, x$1);
    }

    public Symbols.Symbol evaluateMethod(Contexts.Context x$1) {
        return Symbols$.MODULE$.toClassDenot(this.expressionClass(x$1), x$1).info(x$1).decl(Names$.MODULE$.termName("evaluate"), x$1).symbol();
    }

    private ExpressionCompilerConfig copy(String packageName, String outputClassName, int breakpointLine, String expression, Set<String> localVariables, Consumer<String> errorReporter) {
        return new ExpressionCompilerConfig(packageName, outputClassName, breakpointLine, expression, localVariables, errorReporter, this.testMode());
    }

    private String copy$default$1() {
        return this.packageName;
    }

    private String copy$default$2() {
        return this.outputClassName;
    }

    private int copy$default$3() {
        return this.breakpointLine();
    }

    private String copy$default$4() {
        return this.expression();
    }

    private Set<String> copy$default$5() {
        return this.localVariables();
    }

    private Consumer<String> copy$default$6() {
        return this.errorReporter();
    }

    private static Consumer<String> ExpressionCompilerConfig$superArg$1() {
        return _$1 -> {};
    }
}

