/*
    This file is part of the Kasten Framework, made within the KDE community.

    SPDX-FileCopyrightText: 2007, 2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_ABSTRACTGROUPEDVIEWS_HPP
#define KASTEN_ABSTRACTGROUPEDVIEWS_HPP

// lib
#include "abstractviewarea.hpp"

template <class T> class QList;

namespace Kasten {

class AbstractView;
class AbstractGroupedViewsPrivate;

class KASTENGUI_EXPORT AbstractGroupedViews : public AbstractViewArea
{
    Q_OBJECT

protected:
    AbstractGroupedViews();
    KASTENGUI_NO_EXPORT explicit AbstractGroupedViews(std::unique_ptr<AbstractGroupedViewsPrivate>&& dd);

public:
    ~AbstractGroupedViews() override;

public Q_SLOTS: // set/action API to be implemented
    virtual void addViews(const QList<Kasten::AbstractView*>& views) = 0;
    virtual void removeViews(const QList<Kasten::AbstractView*>& views) = 0;
    virtual void setViewFocus(Kasten::AbstractView* view) = 0;

public: // get API to be implemented
    // returns the list in the order of display
    [[nodiscard]]
    virtual QList<AbstractView*> viewList() const = 0;
    [[nodiscard]]
    virtual int viewCount() const = 0;
    [[nodiscard]]
    virtual AbstractView* viewFocus() const = 0;

Q_SIGNALS:
    // view was created and already added to the list
    void added(const QList<Kasten::AbstractView*>& views);
    // view will be removed, already removed from list
    void removing(const QList<Kasten::AbstractView*>& views);
    // closing the view is requested
    void closeRequest(const QList<Kasten::AbstractView*>& views);
    void viewFocusChanged(Kasten::AbstractView* view);

private:
    Q_DECLARE_PRIVATE(AbstractGroupedViews)
};

}

#endif
