//--------------------------------------------------------------
// Radial Blur
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Radial Blur", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( CentreX, "Origin", kNoGroup, "SpecifiesPointX", 0.5, 0.0, 1.0 );
DeclareFloatParam( CentreY, "Origin", kNoGroup, "SpecifiesPointY", 0.5, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );

DeclareEntryPoint()
{
   float4 ret;

   if ( IsOutOfBounds( uv1 ) )
   {
      ret = kTransparentBlack;
   }
   else
   {
      float2 amount = float2( 3 / _OutputWidth, 3 / _OutputHeight );

      float centreY = 1.0 - CentreY;

      float x = uv1.x - CentreX;
      float y = uv1.y - centreY;

      float2 adj = 1.0 - amount;

      ret = tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      adj -= amount;
      ret += tex2D( Input, float2( x * adj.x + CentreX, y * adj.y + centreY ) );

      float4 source = tex2D( Input, uv1 );
      ret = lerp( source, ret / 10, source.a );

     ret = lerp( source, ret, tex2D( Mask, uv1) );
   }

   return ret;
}
