//--------------------------------------------------------------
// Posterize
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Posterize", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amount, "Amount", kNoGroup, kNoFlags, 0.16, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 source = ReadPixel( Input, uv1 );

   int granularity = int( Amount * 255.0 );

   if ( granularity == 0 )
   {
      granularity = 1;
   }

   float4 ret = floor( ( source * 255.0 ) / granularity );
   ret = ( ( ret * granularity ) + ( granularity / 2 ) ) / 255.0;
   ret.a = 1.0;
   
   ret = lerp( source, ret, source.a );

   return lerp( source, ret, tex2D( Mask, uv1 ) );
}
