//--------------------------------------------------------------//
// Flop
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
#include "_utils.fx"

DeclareLightworksEffect( "Flop", "DVE", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
DeclareInput( Input );
DeclareMask;

DeclareIntParam( _InputOrientation );

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
DeclareEntryPoint()
{
   float2 pos =
      ( ( _InputOrientation == 0 ) || ( _InputOrientation == 180 ) ) ? float2 ( 1.0 - uv1.x, uv1.y ) : float2 ( uv1.x, 1.0 - uv1.y );

   float4 source  = ReadPixel( Input, uv1 );
   float4 flopVal = ReadPixel( Input, pos );

   return lerp( source, flopVal, tex2D( Mask, uv1 ) );
}
