//--------------------------------------------------------------
// PlanarYUVToARGB.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( PlanarYUVToARGB, Internal, Colour, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( c1, Point );
DeclareInput( c2, Point );
DeclareInput( c3, Point );

DeclareFloat3Param( ccCoefsAdd1 );
DeclareFloat3x3Param( ccCoefsMul2 );
DeclareFloat3Param( ccCoefsAdd3 );

DeclareFloatParam( Width );
DeclareFloatParam( ChromaStep );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------

// R = Y + 1.402     * Cr
// G = Y - 0.7141363 * Cr - 0.3441363 * Cb
// B = Y                  + 1.772     * Cb

// Substituting constants for BT-709:

// R = Y + 1.5748031 * Cr
// G = Y - 0.4681252 * Cr - 0.1872927 * Cb
// B = Y                  + 1.8552876 * Cb

//The above assume that the input ranges are Y 0..1, Cr and Cb -0.5..+0.5. This does not correspond
//to the values normally used which will, in 10-bit land, be 64-940 for Y, 64-963 for Cr and Cb.

DeclareEntryPoint()
{
   // for each QUAD pixel (x,y) we read word 1 to 4 of each plane
   int Yx = int( fmod( uv1.x * Width, 4) );

   // but repeat 2 or 4 Chroma samples for each Y
   int Cx = int( fmod( uv2.x * Width / ChromaStep, 4 ) );

   float3 yuv;

   int4 map = int4( 2, 1, 0, 3 );

   yuv.r = tex2D( c1, uv1 )[ map[ Yx ] ];
   yuv.b = tex2D( c2, uv2 )[ map[ Cx ] ];
   yuv.g = tex2D( c3, uv3 )[ map[ Cx ] ];

   float4 ret;

   ret.rgb = mul(yuv + ccCoefsAdd1, ccCoefsMul2) + ccCoefsAdd3;

   ret.a = 1;

   return ret;
}
