//--------------------------------------------------------------//
// PlanarRGBToARGB
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( PlanarRGBToARGB, Internal, Colour, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( c1, Point );
DeclareInput( c2, Point );
DeclareInput( c3, Point );

DeclareFloatParam( Width );
DeclareFloatParam( Normalise );

DeclareEntryPoint()
{
   float4 ret;

   // for each QUAD pixel (x,y) we read word 1 to 4 of each plane
   int Cx = int( fmod( uv1.x * Width, 4 ) );

   //
   ret.g = tex2D( c1, uv1 )[ Cx ];
   ret.b = tex2D( c2, uv2 )[ Cx ];
   ret.r = tex2D( c3, uv3 )[ Cx ];

   // normalise 10/12 bit etc.
   ret.rgb *= Normalise;

   ret.a = 1.;

   return ret;
}
