// This file was generated by qtwaylandscanner
// source file is drm.xml

#ifndef QT_WAYLAND_SERVER_DRM
#define QT_WAYLAND_SERVER_DRM

#include "wayland-server-core.h"
#include "wayland-drm-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  wl_drm
    {
    public:
        wl_drm(struct ::wl_client *client, int id, int version);
        wl_drm(struct ::wl_display *display, int version);
        wl_drm(struct ::wl_resource *resource);
        wl_drm();

        virtual ~wl_drm();

        class Resource
        {
        public:
            Resource() : drm_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wl_drm *drm_object;
            wl_drm *object() { return drm_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_authenticate_fail = 0,
            error_invalid_format = 1,
            error_invalid_name = 2,
        };

        enum format {
            format_c8 = 0x20203843,
            format_rgb332 = 0x38424752,
            format_bgr233 = 0x38524742,
            format_xrgb4444 = 0x32315258,
            format_xbgr4444 = 0x32314258,
            format_rgbx4444 = 0x32315852,
            format_bgrx4444 = 0x32315842,
            format_argb4444 = 0x32315241,
            format_abgr4444 = 0x32314241,
            format_rgba4444 = 0x32314152,
            format_bgra4444 = 0x32314142,
            format_xrgb1555 = 0x35315258,
            format_xbgr1555 = 0x35314258,
            format_rgbx5551 = 0x35315852,
            format_bgrx5551 = 0x35315842,
            format_argb1555 = 0x35315241,
            format_abgr1555 = 0x35314241,
            format_rgba5551 = 0x35314152,
            format_bgra5551 = 0x35314142,
            format_rgb565 = 0x36314752,
            format_bgr565 = 0x36314742,
            format_rgb888 = 0x34324752,
            format_bgr888 = 0x34324742,
            format_xrgb8888 = 0x34325258,
            format_xbgr8888 = 0x34324258,
            format_rgbx8888 = 0x34325852,
            format_bgrx8888 = 0x34325842,
            format_argb8888 = 0x34325241,
            format_abgr8888 = 0x34324241,
            format_rgba8888 = 0x34324152,
            format_bgra8888 = 0x34324142,
            format_xrgb2101010 = 0x30335258,
            format_xbgr2101010 = 0x30334258,
            format_rgbx1010102 = 0x30335852,
            format_bgrx1010102 = 0x30335842,
            format_argb2101010 = 0x30335241,
            format_abgr2101010 = 0x30334241,
            format_rgba1010102 = 0x30334152,
            format_bgra1010102 = 0x30334142,
            format_yuyv = 0x56595559,
            format_yvyu = 0x55595659,
            format_uyvy = 0x59565955,
            format_vyuy = 0x59555956,
            format_ayuv = 0x56555941,
            format_xyuv8888 = 0x56555958,
            format_nv12 = 0x3231564e,
            format_nv21 = 0x3132564e,
            format_nv16 = 0x3631564e,
            format_nv61 = 0x3136564e,
            format_yuv410 = 0x39565559,
            format_yvu410 = 0x39555659,
            format_yuv411 = 0x31315559,
            format_yvu411 = 0x31315659,
            format_yuv420 = 0x32315559,
            format_yvu420 = 0x32315659,
            format_yuv422 = 0x36315559,
            format_yvu422 = 0x36315659,
            format_yuv444 = 0x34325559,
            format_yvu444 = 0x34325659,
            format_abgr16f = 0x48344241,
            format_xbgr16f = 0x48344258,
        };

        enum capability {
            capability_prime = 1, // wl_drm prime available
        };

        void send_device(const QString &name);
        void send_device(struct ::wl_resource *resource, const QString &name);
        void send_format(uint32_t format);
        void send_format(struct ::wl_resource *resource, uint32_t format);
        void send_authenticated();
        void send_authenticated(struct ::wl_resource *resource);
        void send_capabilities(uint32_t value);
        void send_capabilities(struct ::wl_resource *resource, uint32_t value);

    protected:
        virtual Resource *drm_allocate();

        virtual void drm_destroy_global();

        virtual void drm_bind_resource(Resource *resource);
        virtual void drm_destroy_resource(Resource *resource);

        virtual void drm_authenticate(Resource *resource, uint32_t id);
        virtual void drm_create_buffer(Resource *resource, uint32_t id, uint32_t name, int32_t width, int32_t height, uint32_t stride, uint32_t format);
        virtual void drm_create_planar_buffer(Resource *resource, uint32_t id, uint32_t name, int32_t width, int32_t height, uint32_t format, int32_t offset0, int32_t stride0, int32_t offset1, int32_t stride1, int32_t offset2, int32_t stride2);
        virtual void drm_create_prime_buffer(Resource *resource, uint32_t id, int32_t name, int32_t width, int32_t height, uint32_t format, int32_t offset0, int32_t stride0, int32_t offset1, int32_t stride1, int32_t offset2, int32_t stride2);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wl_drm_interface m_wl_drm_interface;

        static void handle_authenticate(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);
        static void handle_create_buffer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t name,
            int32_t width,
            int32_t height,
            uint32_t stride,
            uint32_t format);
        static void handle_create_planar_buffer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t name,
            int32_t width,
            int32_t height,
            uint32_t format,
            int32_t offset0,
            int32_t stride0,
            int32_t offset1,
            int32_t stride1,
            int32_t offset2,
            int32_t stride2);
        static void handle_create_prime_buffer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            int32_t name,
            int32_t width,
            int32_t height,
            uint32_t format,
            int32_t offset0,
            int32_t stride0,
            int32_t offset1,
            int32_t stride1,
            int32_t offset2,
            int32_t stride2);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wl_drm *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
