/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.asta.ColumnDefinition;
import net.sf.mpxj.asta.DatatypeConverter;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.TableDefinition;

class TextFileRow
extends MapRow {
    public TextFileRow(TableDefinition table, List<String> data, boolean epochDateFormat) throws MPXJException {
        super(new HashMap<String, Object>());
        ColumnDefinition[] columns = table.getColumns();
        for (int index = 0; index < columns.length; ++index) {
            ColumnDefinition column = columns[index];
            if (index >= data.size() || column == null) continue;
            this.m_map.put(column.getName(), this.getColumnValue(table.getName(), column.getName(), data.get(index), column.getType(), epochDateFormat));
        }
    }

    private Object getColumnValue(String table, String column, String data, int type, boolean epochDateFormat) throws MPXJException {
        try {
            Object value;
            switch (type) {
                case -7: {
                    value = DatatypeConverter.parseBoolean(data);
                    break;
                }
                case -1: 
                case 12: {
                    value = DatatypeConverter.parseString(data);
                    break;
                }
                case 92: {
                    value = DatatypeConverter.parseBasicTime(data);
                    break;
                }
                case 93: {
                    if (epochDateFormat) {
                        value = DatatypeConverter.parseEpochTimestamp(data);
                        break;
                    }
                    value = DatatypeConverter.parseBasicTimestamp(data);
                    break;
                }
                case 8: {
                    value = DatatypeConverter.parseDouble(data);
                    break;
                }
                case 4: {
                    value = DatatypeConverter.parseInteger(data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type);
                }
            }
            return value;
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to parse " + table + "." + column + " (data=" + data + ", type=" + type + ")", ex);
        }
    }
}

