/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.binder;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.binder.BinderUtils;
import com.jgoodies.binding.binder.SelectionInListBindingBuilder;
import com.jgoodies.binding.binder.SelectionInListBindingBuilderImpl;
import com.jgoodies.binding.binder.ValueModelBindingBuilder;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ValueModelBindingBuilderImpl
implements ValueModelBindingBuilder {
    private final ValueModel valueModel;
    private final String propertyName;

    public ValueModelBindingBuilderImpl(ValueModel valueModel) {
        this(valueModel, null);
    }

    public ValueModelBindingBuilderImpl(ValueModel valueModel, String propertyName) {
        this.valueModel = Preconditions.checkNotNull(valueModel, "The ValueModel must not be null.");
        this.propertyName = propertyName;
        if (propertyName != null) {
            Preconditions.checkNotBlank(propertyName, "The bean property name must not be empty, or whitespace.");
        }
    }

    @Override
    public ValueModelBindingBuilder converted(BindingConverter converter) {
        return new ValueModelBindingBuilderImpl(new ConverterValueModel(this.getValueModel(), converter), this.getPropertyName());
    }

    @Override
    public ValueModelBindingBuilder formatted(Format format) {
        return new ValueModelBindingBuilderImpl(ConverterFactory.createStringConverter(this.getValueModel(), format), this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder asSelectionIn(E[] array) {
        Preconditions.checkNotNull(array, "The array must not be null.");
        SelectionInList<E> selectionInList = new SelectionInList<E>(array, this.getValueModel());
        return new SelectionInListBindingBuilderImpl(selectionInList, this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder asSelectionIn(List<E> list) {
        Preconditions.checkNotNull(list, "The List must not be null.");
        SelectionInList<E> selectionInList = new SelectionInList<E>(list, this.getValueModel());
        return new SelectionInListBindingBuilderImpl(selectionInList, this.getPropertyName());
    }

    @Override
    public <E> SelectionInListBindingBuilder asSelectionIn(ListModel listModel) {
        Preconditions.checkNotNull(listModel, "The ListModel must not be null.");
        SelectionInList selectionInList = new SelectionInList(listModel, this.getValueModel());
        return new SelectionInListBindingBuilderImpl(selectionInList, this.getPropertyName());
    }

    @Override
    public void to(AbstractButton toggleButton) {
        Preconditions.checkNotNull(toggleButton, "The toggle button must not be null.");
        Bindings.bind(toggleButton, this.valueModel);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(AbstractButton toggleButton, Object selectedValue, Object deselectedValue) {
        Preconditions.checkNotNull(toggleButton, "The toggle button must not be null.");
        Bindings.bind(toggleButton, this.valueModel, selectedValue, deselectedValue);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(AbstractButton toggleButton, Object choice) {
        Preconditions.checkNotNull(toggleButton, "The toggle button must not be null.");
        Bindings.bind(toggleButton, this.valueModel, choice);
        this.setValidationMessageKey(toggleButton);
    }

    @Override
    public void to(JFormattedTextField formattedTextField) {
        Preconditions.checkNotNull(formattedTextField, "The formatted text field must not be null.");
        Bindings.bind(formattedTextField, this.valueModel);
        this.setValidationMessageKey(formattedTextField);
    }

    @Override
    public void to(JLabel label) {
        Preconditions.checkNotNull(label, "The label must not be null.");
        Bindings.bind(label, this.valueModel);
    }

    @Override
    public void to(JTextArea textArea) {
        this.to(textArea, ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
    }

    @Override
    public void to(JTextArea textArea, ValueModelBindingBuilder.Commit commitType) {
        Preconditions.checkNotNull(textArea, "The text area must not be null.");
        Preconditions.checkNotNull(commitType, "The commit type must not be null.");
        Bindings.bind(textArea, this.valueModel, commitType == ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        this.setValidationMessageKey(textArea);
    }

    @Override
    public void to(JTextField textField) {
        if (textField instanceof JFormattedTextField) {
            this.to((JFormattedTextField)textField);
        } else {
            this.to(textField, ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        }
    }

    @Override
    public void to(JTextField textField, ValueModelBindingBuilder.Commit commitType) {
        Preconditions.checkNotNull(textField, "The text field must not be null.");
        Preconditions.checkNotNull(commitType, "The commit type must not be null.");
        Preconditions.checkArgument(!(textField instanceof JFormattedTextField), "For JFormattedTextField use method #to(JFormattedTextField)");
        Bindings.bind(textField, this.valueModel, commitType == ValueModelBindingBuilder.Commit.ON_FOCUS_LOST);
        this.setValidationMessageKey(textField);
    }

    protected final ValueModel getValueModel() {
        return this.valueModel;
    }

    protected final String getPropertyName() {
        return this.propertyName;
    }

    protected final void setValidationMessageKey(JComponent comp) {
        if (this.getPropertyName() != null) {
            BinderUtils.setValidationMessageKey(comp, this.getPropertyName());
        }
    }
}

