/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#ifndef AVOGADRO_QUANTUMIO_GENERICJSON_H
#define AVOGADRO_QUANTUMIO_GENERICJSON_H

#include "avogadroquantumioexport.h"
#include <avogadro/io/fileformat.h>

#include <map>
#include <vector>

namespace Avogadro {
namespace QuantumIO {

class AVOGADROQUANTUMIO_EXPORT GenericJson : public Io::FileFormat
{
public:
  GenericJson();
  ~GenericJson() override;

  Operations supportedOperations() const override
  {
    return Read | File | Stream | String;
    // TODO add write operation
  }

  FileFormat* newInstance() const override { return new GenericJson; }
  std::string identifier() const override { return "Avogadro: Generic JSON"; }
  std::string name() const override { return "Generic JSON"; }
  std::string description() const override { return "Generic JSON format."; }

  std::string specificationUrl() const override { return ""; }

  std::vector<std::string> fileExtensions() const override;
  std::vector<std::string> mimeTypes() const override;

  [[nodiscard]] bool read(std::istream& in, Core::Molecule& molecule) override;
  [[nodiscard]] bool write(std::ostream&, const Core::Molecule&) override
  {
    // Empty, as we do not currently write QC_SCHEMA files.
    return false;
  }
};

} // namespace QuantumIO
} // namespace Avogadro

#endif
